% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.netimpact.R
\name{print.netimpact}
\alias{print.netimpact}
\title{Print method for objects of class netimpact}
\usage{
\method{print}{netimpact}(
  x,
  common = x$x$common,
  random = x$x$random,
  digits = gs("digits.prop"),
  legend = TRUE,
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{netimpact}.}

\item{common}{A logical indicating whether results for the common
effects model should be printed.}

\item{random}{A logical indicating whether results for the random
effects model should be printed.}

\item{digits}{Minimal number of significant digits.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\description{
Print method for objects of class \code{netimpact}.
}
\examples{
data(Franchini2012)

# Only consider first two studies (to reduce runtime of example)
#
studies <- unique(Franchini2012$Study)
p1 <- pairwise(list(Treatment1, Treatment2, Treatment3),
  n = list(n1, n2, n3),
  mean = list(y1, y2, y3), sd = list(sd1, sd2, sd3),
  data = subset(Franchini2012, Study \%in\% studies[1:2]),
  studlab = Study)

net1 <- netmeta(p1)
ni <- netimpact(net1, verbose = TRUE)
ni

}
\seealso{
\code{\link{netimpact}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{print}
