% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netconnection.R
\name{netconnection.default}
\alias{netconnection.default}
\alias{netconnection}
\alias{print.netconnection}
\alias{netconnection.pairwise}
\title{Get information on network connectivity (number of subnetworks,
distance matrix)}
\usage{
\method{netconnection}{default}(
  data = NULL,
  treat1,
  treat2,
  studlab = NULL,
  subset = NULL,
  sep.trts = ":",
  nchar.trts = 666,
  title = "",
  details.disconnected = FALSE,
  warn = FALSE,
  ...
)

\method{netconnection}{pairwise}(
  data,
  sep.trts = ":",
  nchar.trts = 666,
  title = "",
  details.disconnected = FALSE,
  warn = FALSE,
  ...
)

\method{print}{netconnection}(
  x,
  digits = max(4, .Options$digits - 3),
  nchar.trts = x$nchar.trts,
  details = FALSE,
  details.disconnected = x$details.disconnected,
  ...
)

netconnection(data, ...)
}
\arguments{
\item{data}{An optional data frame containing the study
information.}

\item{treat1}{Label / number for first treatment or a data frame
created with \code{\link{pairwise}}.}

\item{treat2}{Label / number for second treatment.}

\item{studlab}{An optional - but important! - vector with study
labels (see Details).}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{sep.trts}{A character used in comparison names as separator
between treatment labels.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{title}{Title of meta-analysis / systematic review.}

\item{details.disconnected}{A logical indicating whether to print
more details for disconnected networks.}

\item{warn}{A logical indicating whether warnings should be
printed.}

\item{\dots}{Additional arguments (ignored at the moment)}

\item{x}{An object of class \code{netconnection}.}

\item{digits}{Minimal number of significant digits, see
\code{\link{print.default}}.}

\item{details}{A logical indicating whether to print the distance
matrix.}
}
\value{
An object of class \code{netconnection} with corresponding
\code{print} function. The object is a list containing the
following components:
\item{treat1, treat2, studlab, title, warn, nchar.trts}{As defined
  above.}
\item{k}{Total number of studies.}
\item{m}{Total number of pairwise comparisons.}
\item{n}{Total number of treatments.}
\item{n.subnets}{Number of subnetworks; equal to 1 for a fully
  connected network.}
\item{D.matrix}{Distance matrix.}
\item{A.matrix}{Adjacency matrix.}
\item{L.matrix}{Laplace matrix.}
\item{call}{Function call.}
\item{version}{Version of R package netmeta used to create object.}
}
\description{
To determine the network structure and to test whether a given
network is fully connected. Network information is provided as a
triple of vectors \code{treat1}, \code{treat2}, and \code{studlab}
where each row corresponds to an existing pairwise treatment
comparison (\code{treat1}, \code{treat2}) in a study
(\code{studlab}). The function calculates the number of subnetworks
(connectivity components; value of 1 corresponds to a fully
connected network) and the distance matrix (in block-diagonal form
in the case of subnetworks). If some treatments are combinations of
other treatments or have common components, an analysis based on
the additive network meta-analysis model might be possible, see
\link{discomb} function.
}
\examples{
data(Senn2013)

nc1 <- netconnection(treat1, treat2, studlab, data = Senn2013)
nc1

# Extract number of (sub)networks
#
nc1$n.subnets

# Extract distance matrix
#
nc1$D.matrix

\dontrun{
# Conduct network meta-analysis (results not shown)
#
net1 <- netmeta(TE, seTE, treat1, treat2, studlab, data = Senn2013)

# Artificial example with two subnetworks
#
t1 <- c("G", "B", "B", "D", "A", "F")
t2 <- c("B", "C", "E", "E", "H", "A")
#
nc2 <- netconnection(t1, t2)
print(nc2, details = TRUE)

# Number of subnetworks
#
nc2$n.subnets

# Extract distance matrix
#
nc2$D.matrix

# Conduct network meta-analysis (results in an error message due to
# unconnected network)
try(net2 <- netmeta(1:6, 1:6, t1, t2, 1:6))

# Conduct network meta-analysis on first subnetwork
#
net2.1 <- netmeta(1:6, 1:6, t1, t2, 1:6, subset = nc2$subnet == 1)

# Conduct network meta-analysis on second subnetwork
#
net2.2 <- netmeta(1:6, 1:6, t1, t2, 1:6, subset = nc2$subnet == 2)

net2.1
net2.2
}  

}
\seealso{
\code{\link{netmeta}}, \code{\link{netdistance}},
  \code{\link{discomb}}
}
\author{
Gerta Rücker \email{gerta.ruecker@uniklinik-freiburg.de}, Guido
  Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
