% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rankogram.R
\name{plot.rankogram}
\alias{plot.rankogram}
\title{Plot rankograms}
\usage{
\method{plot}{rankogram}(
  x,
  type = if (cumulative.rankprob) "step" else "bar",
  pooled = ifelse(x$random, "random", "common"),
  sort = TRUE,
  trts,
  cumulative.rankprob = x$cumulative.rankprob,
  ylim,
  ylab,
  nchar.trts = x$nchar.trts,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{rankogram}}.}

\item{type}{A character string specifying whether a "bar" chart, a
"line" graph, or "step" functions should be drawn. Can be
abbreviated.}

\item{pooled}{A character string indicating whether results for the
common (\code{"common"}) or random effects model (\code{"random"})
should be plotted. Can be abbreviated.}

\item{sort}{A logical indicating whether treatments should be
sorted by decreasing SUCRAs.}

\item{trts}{Treatment(s) to show in rankogram.}

\item{cumulative.rankprob}{A logical indicating whether cumulative
ranking probabilites should be shown.}

\item{ylim}{The y limits (min, max) of the plot.}

\item{ylab}{A label for the y-axis.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{\dots}{Additional graphical arguments (ignored at the
moment).}
}
\description{
This function produces a rankogram, i.e., an image plot of ranking
probabilities for all treatments.
}
\details{
This function produces an image plot of (cumulative) ranking
probabilities for all treatments as a bar graph, a line graph or as
step functions (argument \code{type}).

By default (argument \code{pooled}), results for the random effects
model are shown if a network meta-analysis was conducted for both
the common and random effects model.

Treatments are sorted according to their mean effects if argument
\code{sort = TRUE} (default).  A subset of treatments can be
specified using argument \code{trts}.

Cumulative ranking probabilites are shown if
\code{cumulative.rankprob = TRUE}. By default, step functions are
shown for cumulative ranking probabilites.
}
\examples{
data(Woods2010)
p1 <- pairwise(treatment, event = r, n = N, studlab = author,
  data = Woods2010, sm = "OR")
net1 <- netmeta(p1, small.values = "good")

ran1 <- rankogram(net1, nsim = 100)
ran1

plot(ran1)
plot(ran1, type = "l")
plot(ran1, cumulative.rankprob = TRUE)

}
\references{
Salanti G, Ades AE, Ioannidis JP (2011):
Graphical methods and numerical summaries for presenting results
from multiple-treatment meta-analysis: an overview and tutorial.
\emph{Journal of Clinical Epidemiology},
\bold{64}, 163--71
}
\seealso{
\code{\link{rankogram}}
}
\author{
Theodoros Papakonstantinou \email{dev@tpapak.com}, Guido
  Schwarzer \email{sc@imbi.uni-freiburg.de}
}
