% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.netrank.R
\name{plot.netrank}
\alias{plot.netrank}
\title{Plot treatment ranking(s) of network meta-analyses}
\usage{
\method{plot}{netrank}(
  ...,
  name,
  common,
  random,
  seq,
  low = "red",
  mid = "yellow",
  high = "green",
  col = "black",
  main,
  main.size = 14,
  main.col = col,
  main.face = "bold",
  legend = TRUE,
  axis.size = 12,
  axis.col = col,
  axis.face = "plain",
  na.value = "grey50",
  angle = 45,
  hjust.x = 1,
  vjust.x = 1,
  hjust.y = 1,
  vjust.y = 0,
  nchar.trts,
  digits = 3,
  fixed,
  comb.fixed,
  comb.random,
  warn.deprecated = gs("warn.deprecated")
)
}
\arguments{
\item{...}{A single netrank object or a list of netrank objects.}

\item{name}{An optional character vector providing descriptive
names for the network meta-analysis objects.}

\item{common}{A logical indicating whether results for the common
effects model should be plotted.}

\item{random}{A logical indicating whether results for the random
effects model should be plotted.}

\item{seq}{A character or numerical vector specifying the sequence
of treatments on the x-axis.}

\item{low}{A character string defining the colour for a P-score of
0, see \code{\link[ggplot2]{scale_fill_gradient2}}.}

\item{mid}{A character string defining the colour for a P-score of
0.5, see \code{\link[ggplot2]{scale_fill_gradient2}}.}

\item{high}{A character string defining the colour for a P-score of
1, see \code{\link[ggplot2]{scale_fill_gradient2}}.}

\item{col}{Colour of text.}

\item{main}{Title.}

\item{main.size}{Font size of title, see
\code{\link[ggplot2]{element_text}}.}

\item{main.col}{Colour of title, see
\code{\link[ggplot2]{element_text}}.}

\item{main.face}{Font face of title, see
\code{\link[ggplot2]{element_text}}.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{axis.size}{Font size of axis text, see
\code{\link[ggplot2]{element_text}}.}

\item{axis.col}{Colour of axis text, see
\code{\link[ggplot2]{element_text}}.}

\item{axis.face}{Font face of axis text, see
\code{\link[ggplot2]{element_text}}.}

\item{na.value}{Colour for missing values, see
\code{\link[ggplot2]{scale_fill_gradient2}}.}

\item{angle}{Angle for text on x-axis, see
\code{\link[ggplot2]{element_text}}.}

\item{hjust.x}{A numeric between 0 and 1 with horizontal
justification of text on x-axis, see
\code{\link[ggplot2]{element_text}}.}

\item{vjust.x}{A numeric between 0 and 1 with vertical
justification of text on x-axis, see
\code{\link[ggplot2]{element_text}}.}

\item{hjust.y}{A numeric between 0 and 1 with horizontal
justification of text on y-axis, see
\code{\link[ggplot2]{element_text}}.}

\item{vjust.y}{A numeric between 0 and 1 with vertical
justification of text on y-axis, see
\code{\link[ggplot2]{element_text}}.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{fixed}{Deprecated argument (replaced by 'common').}

\item{comb.fixed}{Deprecated argument (replaced by 'common').}

\item{comb.random}{Deprecated argument (replaced by 'random').}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}
}
\value{
A ggplot2 object or NULL if no ranking was conducted.
}
\description{
Produce an image plot of treatment ranking(s) generated with R
function \code{netrank}.
}
\details{
This function produces an image plot of network rankings (Palpacuer
et al., 2018, Figure 4). Note, a scatter plot of two network
rankings can be generated with \code{\link{plot.netposet}}.

By default, treatments are ordered by decreasing P-scores of the
first network meta-analysis object. Argument \code{seq} can be used
to specify a differenct treatment order.
}
\examples{
\dontrun{
# Use depression dataset
#
data(Linde2015)

# Define order of treatments
#
trts <- c("TCA", "SSRI", "SNRI", "NRI",
  "Low-dose SARI", "NaSSa", "rMAO-A", "Hypericum", "Placebo")

# Outcome labels
#
outcomes <- c("Early response", "Early remission")

# (1) Early response
#
p1 <- pairwise(treat = list(treatment1, treatment2, treatment3),
  event = list(resp1, resp2, resp3), n = list(n1, n2, n3),
  studlab = id, data = Linde2015, sm = "OR")
#
net1 <- netmeta(p1, common = FALSE,
  seq = trts, ref = "Placebo")

# (2) Early remission
#
p2 <- pairwise(treat = list(treatment1, treatment2, treatment3),
  event = list(remi1, remi2, remi3), n = list(n1, n2, n3),
  studlab = id, data = Linde2015, sm = "OR")
#
net2 <- netmeta(p2, common = FALSE,
  seq = trts, ref = "Placebo")

# Image plot of treatment rankings (two outcomes)
#
plot(netrank(net1, small.values = "bad"),
  netrank(net2, small.values = "bad"),
  name = outcomes, digits = 2)


# Outcome labels
#
outcomes <- c("Early response", "Early remission",
  "Lost to follow-up", "Lost to follow-up due to AEs",
  "Adverse events (AEs)")

# (3) Loss to follow-up
#
p3 <- pairwise(treat = list(treatment1, treatment2, treatment3),
  event = list(loss1, loss2, loss3), n = list(n1, n2, n3),
  studlab = id, data = Linde2015, sm = "OR")
#
net3 <- netmeta(p3, common = FALSE, seq = trts, ref = "Placebo")

# (4) Loss to follow-up due to adverse events
#
p4 <- pairwise(treat = list(treatment1, treatment2, treatment3),
  event = list(loss.ae1, loss.ae2, loss.ae3), n = list(n1, n2, n3),
  studlab = id, data = subset(Linde2015, id != 55), sm = "OR")
#
net4 <- netmeta(p4, common = FALSE, seq = trts, ref = "Placebo")

# (5) Adverse events
#
p5 <- pairwise(treat = list(treatment1, treatment2, treatment3),
  event = list(ae1, ae2, ae3), n = list(n1, n2, n3),
  studlab = id, data = Linde2015, sm = "OR")
#
net5 <- netmeta(p5, common = FALSE, seq = trts, ref = "Placebo")

# Image plot of treatment rankings (two outcomes)
#
plot(netrank(net1, small.values = "bad"),
  netrank(net2, small.values = "bad"),
  netrank(net3, small.values = "good"),
  netrank(net4, small.values = "good"),
  netrank(net5, small.values = "good"),
  name = outcomes, digits = 2)
}

}
\references{
Palpacuer C, Duprez R, Huneau A, Locher C, Boussageon R, Laviolle
B, et al. (2018):
Pharmacologically controlled drinking in the treatment of alcohol
dependence or alcohol use disorders: a systematic review with
direct and network meta-analyses on nalmefene, naltrexone,
acamprosate, baclofen and topiramate.
\emph{Addiction},
\bold{113}, 220--37
}
\seealso{
\code{\link{netrank}}, \code{\link{netmeta}},
  \code{\link{netposet}}, \code{\link{hasse}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}, Clément
  Palpacuer \email{clementpalpacuer@gmail.com}
}
\keyword{hplot}
