% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_egoalter.R
\name{select_egoalter}
\alias{select_egoalter}
\title{Calculate the number of adoption changes between ego and alter.}
\usage{
select_egoalter(graph, adopt, period = NULL)
}
\arguments{
\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{adopt}{\eqn{n\times T}{n*T} matrix. Cumulative adoption matrix obtained from \code{\link{toa_mat}}.}

\item{period}{Integer scalar. Optional to make the count for a particular period of time.}
}
\value{
An dataframe with \eqn{n\times (T-1)}{n * (T-1)} rows and
\eqn{2 + 16\times 3}{2 + 16 * 3} columns. The column names are
\item{\code{time}}{Integer represting the time period}
\item{\code{id}}{Node id}
\item{\code{select_a_01}, \dots, \code{select_a_16}}{Number of new links classified
between categories 1 to 16.}
\item{\code{select_d_01}, \dots, \code{select_d_16}}{Number of remove links classified
between categories 1 to 16.}
\item{\code{select_s_01}, \dots, \code{select_s_16}}{Number of unchanged links
classified between categories 1 to 16.}
}
\description{
This function calculates the 16 possible configurations between ego and alter
over two time points in terms of their behavior and tie changes.  From time
one to time two, given a binary state of behavior, ego and alter can be
related in 16 different ways.
}
\details{
The 16 possibilities are summarized in this matrix:

\tabular{rrrcccc}{
      \tab       \tab       \tab Alter \tab     \tab     \tab     \cr
      \tab       \tab \eqn{t-1}   \tab  No   \tab     \tab Yes \tab     \cr
      \tab \eqn{t-1}   \tab \eqn{t}     \tab  No   \tab Yes \tab No  \tab Yes \cr
  Ego \tab No    \tab No    \tab   1   \tab  2  \tab   9 \tab  10 \cr
      \tab       \tab Yes   \tab   3   \tab  4  \tab 11  \tab  12 \cr
      \tab Yes   \tab No    \tab   5   \tab  6  \tab 13  \tab  14 \cr
      \tab       \tab Yes   \tab   7   \tab  8  \tab 15  \tab  16
}

The
first two Yes/No columns represent Ego's adoption of the innovation in \eqn{t-1}
and \eqn{t}; while the first two Yes/No rows represent Alter's adoption of the
innovation in \eqn{t-1} and t respectively. So for example, number 4 means that
while neither of the two had addopted the innovation in \eqn{t-1}, both have in \eqn{t}.
At the same time, number 12 means that ego adopted the innovation in \eqn{t}, but
alter had already adopted in \eqn{t-1} (so it has it in both, \eqn{t} and \eqn{t-1}).
}
\author{
Vega Yon, Dyal, Hayes & Valente
}
\references{
Thomas W. Valente, Stephanie R. Dyal, Kar-Hai Chu, Heather Wipfli, Kayo
Fujimoto, \emph{Diffusion of innovations theory applied to global tobacco control
treaty ratification}, Social Science & Medicine, Volume 145, November 2015,
Pages 89-97, ISSN 0277-9536
(\url{http://dx.doi.org/10.1016/j.socscimed.2015.10.001})
}

