% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nettest.R
\name{phi.moment}
\alias{phi.moment}
\title{Calculate \eqn{\Phi} statistic}
\usage{
phi.moment(A, Y)
}
\arguments{
\item{A}{\code{[n x n]} adjacency matrix or general relational weight matrix of which \eqn{A_ij} indicates relationship from \eqn{i} to \eqn{j}.}

\item{Y}{a vector of \eqn{n} nominal or binary, one-dimensional observations.}
}
\value{
\item{\code{rawphi}}{Non-standardized \eqn{\Phi} statistic.}
\item{\code{m1.rawphi}}{the first (permutation) moment of \code{rawphi}.}
\item{\code{m2.rawphi}}{the second (permutation) moment of \code{rawphi}.}
}
\description{
This is an auxiliary function to calculate non-standardized \eqn{\Phi} statistic and its first and second moment.
}
\author{
Youjin Lee
}
