% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_ER.R
\name{grow_ER}
\alias{grow_ER}
\title{Grow an Erdos-Renyi Random Network}
\usage{
grow_ER(matrix, x, p, retcon = FALSE, directed = TRUE)
}
\arguments{
\item{matrix}{Existing network to experience growth.}

\item{x}{The ID of the node to be grown.}

\item{p}{Probability possible edges exist. Needs to be between zero and one.}

\item{retcon}{Binary variable determining if already existing nodes can attach to new nodes. Defaults to FALSE.}

\item{directed}{Binary variable determining if the network is directed, resulting in off-diagonal asymmetry in the adjacency matrix. Defaults to TRUE.}
}
\value{
An adjacency matrix.
}
\description{
Grows an already existing network by adding a node according to the Erdos-Renyi random mechanism. Nodes can only attach to previously grown nodes.
}
\details{
Different from Duplication & Mutation models in that edges can only be lost.
}
\examples{
# Import netcom
library(netcom)

size <- 10
existing_network <- matrix(sample(c(0,1), size = size^2, replace = TRUE), nrow = size, ncol = size)
new_network_prep <- matrix(0, nrow = size + 1, ncol = size + 1)
new_network_prep[1:size, 1:size] = existing_network
new_network <- grow_ER(matrix = new_network_prep, x = size + 1, p = 0.5)

}
\references{
Erdos, P. and Renyi, A., On random graphs, Publicationes Mathematicae 6, 290–297 (1959).
}
