% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence.R
\name{causal.influence}
\alias{causal.influence}
\title{Identifying causally influential units on social network}
\usage{
causal.influence(targetoutcome = "mean", Avalues, inputY, inputA, listC,
  R.matrix, E.matrix, edgeinfo = NULL, n.obs = 1000, n.burn = 100,
  optim.method = "L-BFGS-B")
}
\arguments{
\item{targetoutcome}{is a targeted couterfactual outcome of probability is in our interest, having different forms depending on the context of influence : 
\describe{
   \item{a vector of length \code{m}}{a vector specifies every element of \strong{y}.}
   \item{a \code{[q x m]} matrix}{a collection of \strong{y_1}, \strong{y_2}, ..., \strong{y_q} of which we want to derive the probability.}
   \item{an integer}{the number of 1's in \strong{y} (\eqn{0 \ge} & \eqn{\le m}).}
   \item{'mean'}{when we want derive E(\strong{Y}(\strong{a})) (default).}
}}

\item{Avalues}{distinct treatment values of which maximum indicates intervention. Defaults to \code{(0,1)}.}

\item{inputY}{a \code{[n x m]} matrix of \code{n} independent outcomes for \code{m} units.}

\item{inputA}{a \code{[n x m]} matrix of \code{n} independent treatment assignments assigned to \code{m} units.}

\item{listC}{is either a matrix, list or \code{NULL}:
\describe{
   \item{a \code{[n x m]} matrix}{a matrix of \code{n} independent confounders for \code{m} units under single confounder.}
   \item{a list of \code{[n x m]} matrices}{a collection of \code{n} independent confounders for \code{m} units under multiple confounders.}
   \item{\code{NULL}}{no confounders.}
}}

\item{R.matrix}{a \code{[m x m]} relational symmetric matrix where \eqn{R.matrix_ij = 1} indicates \eqn{Y_i} and \eqn{Y_j} are adjacent.}

\item{E.matrix}{a \code{[m x m]} matrix where \eqn{E.matrix_ij = 1} indicates \eqn{A_i} has a direct causal effect on \eqn{Y_j}. Defaults to diagonal matrix, which indicates no interference.}

\item{edgeinfo}{a list of matrix specifying additional directed edges (from confounders or treatment to the outcomes) information. Defaults to \code{NULL}.
\describe{
   \item{first column:}{\code{"Y"} indicates outcomes; \code{"A"} indicates treatment; \code{"C"} indicates confounders. Under multiple confounders, \code{"C1"}, \code{"C2"}, ... indicate each confounder.}
   \item{second column:}{an index for unit corresponding to the variable in the first column, \code{i=1,2,...m}.}
}}

\item{n.obs}{the number of Gibbs samplers except for burn-in sample.}

\item{n.burn}{the number of burn-in sample in Gibbs sampling.}

\item{optim.method}{the method used in \code{optim()}. Defaults to \code{"L-BFGS-B"}.}
}
\value{
returns \code{"noconvergence"} in case of failure to converence or a list with components :
\item{\code{influence}}{}
\item{\code{n.par}}{the number of parameters estimated in conditional log-linear model.}
\item{\code{par.est}}{the estimated parameters.}
}
\description{
This function calculates probability associated with counterfactual collective outcome(s)
P(\strong{Y}(\strong{a}_j) = \strong{y}) as a measure of influence of unit \code{j},
where \strong{a}_j indicates the sole intervention of unit \code{j}.
}
\examples{
library(netchain)
set.seed(1234)
weight.matrix <- matrix(c(0.5, 1, 0, 1, 0.3, 0.5, 0, 0.5, -0.5), 3, 3)
simobs <- simGibbs(n.unit = 3, n.gibbs = 100, n.sample = 5, 
                  weight.matrix,
                  treat.matrix = 0.5*diag(3), cov.matrix= (-0.3)*diag(3) )
inputY <- simobs$inputY                   
inputA <- simobs$inputA   
inputC <- simobs$inputC 
R.matrix <- ifelse(weight.matrix==0, 0, 1)
diag(R.matrix) <- 0
edgeinfo <- list(rbind(c("Y", 1), c("C", 1)), rbind(c("Y", 2), c("C", 2)), 
           rbind(c("Y", 3), c("C", 3)))   
# implement a function (take > 10 seconds)
# result <- causal.influence(targetoutcome = "mean", Avalues = c(1,0), inputY, inputA, 
# listC = inputC, R.matrix, E.matrix = diag(3), edgeinfo = edgeinfo)   



}
\author{
Youjin Lee
}
