% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nestfs.R
\name{nested.forward.selection}
\alias{nested.forward.selection}
\title{Run nested forward selection}
\usage{
nested.forward.selection(x, y, init.model, family, folds, ...)
}
\arguments{
\item{x}{Dataframe of predictors: this should include all variables in
the initial set and the variables that are allowed to enter the
selected panel.}

\item{y}{Outcome variable. If \code{family=binomial}, it can only contain
two classes of values that can be coerced to 0-1.}

\item{init.model}{Either a formula or a vector of names of the initial set
of variables that define the model from which the forward selection
should start.}

\item{family}{Type of model fitted: either \code{gaussian()} for linear
regression or \code{binomial()} for logistic regression. This can be
specified also as a function name (\code{gaussian}) or as a string
(\code{"gaussian"}).}

\item{folds}{List of cross-validation folds, where each element contains
the indices of the observations to be withdrawn in that fold.}

\item{...}{Arguments to \code{forward.selection}.}
}
\value{
An object of class \code{nestfs} of length equal to
\code{length(folds)}, where each element is an object of class
\code{fs} containing the following additional fields:
\describe{
\item{fit:}{Predicted values for the withdrawn observations.}
\item{obs:}{Observed values for the withdrawn observations.}
\item{test.idx:}{Indices of the the withdrawn observations for this fold.}
\item{model:}{Summary of the model built using the selected panel.}
}
}
\description{
Run nested forward selection starting from a set of variables or a model.
}
\details{
This function allows to obtain an unbiased estimate of the performance
of the selected panels on withdrawn data by running forward selection on
a predetermined set of folds.
}
\examples{
# register a parallel cluster with two cores
library(doParallel)
registerDoParallel(2)

data(diabetes)
folds <- create.folds(2, nrow(X.diab), seed=1)
nestfs.res <- nested.forward.selection(X.diab, Y.diab, ~ age + sex,
                                       gaussian(), folds, choose.from=1:10,
                                       num.inner.folds=5, max.iters=3)
summary(nestfs.res)

# close the parallel cluster
stopImplicitCluster()

}
\seealso{
\code{\link{forward.selection}}, \code{\link{summary.nestfs}} and
\code{\link{nested.performance}}.
}
\keyword{multivariate}
