% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{correl_filter}
\alias{correl_filter}
\title{Correlation filter}
\usage{
correl_filter(
  y,
  x,
  method = "pearson",
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  type = c("index", "names", "full"),
  keep_factors = TRUE,
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix or dataframe of predictors}

\item{method}{Type of correlation, either "pearson" or "spearman".}

\item{force_vars}{Vector of column names within \code{x} which are always retained
in the model (i.e. not filtered). Default \code{NULL} means all predictors will
be passed to \code{filterFUN}.}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors with
p values < \code{p_cutoff} are returned.}

\item{p_cutoff}{p value cut-off}

\item{rsq_cutoff}{r^2 cutoff for removing predictors due to collinearity.
Default \code{NULL} means no collinearity filtering. Predictors are ranked based
on correlation with the response vector \code{y}. If 2 or more predictors are
collinear, the first ranked predictor is retained, while the other
collinear predictors are removed. See \code{\link[=collinear]{collinear()}}.}

\item{type}{Type of vector returned. Default "index" returns indices,
"names" returns predictor names, "full" returns a matrix of p-values.}

\item{keep_factors}{Logical affecting factors with 3 or more levels.
Dataframes are coerced to a matrix using \link{data.matrix}. Binary
factors are converted to numeric values 0/1 and analysed as such. If
\code{keep_factors} is \code{TRUE} (the default), factors with 3 or more levels are
not filtered and are retained. If \code{keep_factors} is \code{FALSE}, they are
removed.}

\item{...}{Further arguments passed to \link{correls}}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters. If
\code{type} is \code{"full"} full output from \link{correls} is returned.
}
\description{
Filter using correlation (Pearson or Spearman) for ranking variables.
}
