% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_filter.R
\name{stat_filter}
\alias{stat_filter}
\alias{bin_stat_filter}
\alias{class_stat_filter}
\alias{cor_stat_filter}
\title{Univariate filter for binary classification with mixed predictor datatypes}
\usage{
stat_filter(y, x, ...)

bin_stat_filter(
  y,
  x,
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  type = c("index", "names", "full", "list"),
  ...
)

class_stat_filter(
  y,
  x,
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  type = c("index", "names", "full", "list"),
  ...
)

cor_stat_filter(
  y,
  x,
  cor_method = c("pearson", "spearman", "lm"),
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  rsq_cutoff = NULL,
  rsq_method = "pearson",
  type = c("index", "names", "full", "list"),
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix or dataframe of predictors}

\item{...}{optional arguments, e.g. \code{rsq_method}: see \code{\link[=collinear]{collinear()}}.}

\item{force_vars}{Vector of column names within \code{x} which are always retained
in the model (i.e. not filtered). Default \code{NULL} means all predictors will
be passed to \code{filterFUN}.}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors with
p-values < \code{p_cutoff} are returned.}

\item{p_cutoff}{p value cut-off}

\item{rsq_cutoff}{r^2 cutoff for removing predictors due to collinearity.
Default \code{NULL} means no collinearity filtering. Predictors are ranked based
on t-test. If 2 or more predictors are collinear, the first ranked
predictor by t-test is retained, while the other collinear predictors are
removed. See \code{\link[=collinear]{collinear()}}.}

\item{type}{Type of vector returned. Default "index" returns indices, "names"
returns predictor names, "full" returns a dataframe of statistics, "list"
returns a list of 2 matrices of statistics, one for continuous predictors,
one for categorical predictors.}

\item{cor_method}{For \code{cor_stat_filter()} only, either \code{"pearson"},
\code{"spearman"} or \code{"lm"} controlling whether continuous predictors are
filtered by correlation (faster) or regression (slower but allows inclusion
of covariates via \code{force_vars}).}

\item{rsq_method}{character string indicating which correlation coefficient
is to be computed. One of "pearson" (default), "kendall", or "spearman".
See \code{\link[=collinear]{collinear()}}.}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters in order
of test p-value. If \code{type} is \code{"full"} full output is
returned containing a dataframe of statistical results. If \code{type} is
\code{"list"} the output is returned as a list of 2 matrices containing
statistical results separated by continuous and categorical predictors.
}
\description{
Univariate statistic filter for dataframes of predictors with mixed numeric
and categorical datatypes. Different statistical tests are used depending on
the data type of response vector and predictors:
\describe{
\item{Binary class response: \code{bin_stat_filter()}}{t-test for continuous
data, chi-squared test for categorical data}
\item{Multiclass response: \code{class_stat_filter()}}{one-way ANOVA for
continuous data, chi-squared test for categorical data}
\item{Continuous response: \code{cor_stat_filter()}}{correlation (or linear
regression) for continuous data and binary data, one-way ANOVA for
categorical data}
}
}
\details{
\code{stat_filter()} is a wrapper which calls \code{bin_stat_filter()},
\code{class_stat_filter()} or \code{cor_stat_filter()} depending on whether \code{y} is
binary, multiclass or continuous respectively. Ordered factors are converted
to numeric (integer) levels and analysed as if continuous.
}
\examples{
library(mlbench)
data(BostonHousing2)
dat <- BostonHousing2
y <- dat$cmedv  ## continuous outcome
x <- subset(dat, select = -c(cmedv, medv, town))

stat_filter(y, x, type = "full")
stat_filter(y, x, nfilter = 5, type = "names")
stat_filter(y, x)

data(iris)
y <- iris$Species  ## 3 class outcome
x <- subset(iris, select = -Species)
stat_filter(y, x, type = "full")

}
