% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncvreg-package.R
\docType{package}
\name{ncvreg-package}
\alias{ncvreg-package}
\title{ncvreg: Regularization Paths for SCAD and MCP Penalized Regression Models}
\description{
Fits regularization paths for linear regression, GLM, and Cox regression models using lasso or nonconvex penalties, in particular the minimax concave penalty (MCP) and smoothly clipped absolute deviation (SCAD) penalty, with options for additional L2 penalties (the "elastic net" idea). Utilities for carrying out cross-validation as well as post-fitting visualization, summarization, inference, and prediction are also provided. For more information, see Breheny and Huang (2011) \doi{10.1214/10-AOAS388} or visit the ncvreg homepage \url{https://pbreheny.github.io/ncvreg/}.
}
\examples{
\donttest{vignette("getting-started", package="ncvreg")}
}
\references{
Breheny P and Huang J. (2011) Coordinate descent algorithms for
nonconvex penalized regression, with applications to biological feature
selection. \emph{Annals of Applied Statistics}, \strong{5}: 232-253.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://pbreheny.github.io/ncvreg/}
  \item \url{https://github.com/pbreheny/ncvreg}
  \item Report bugs at \url{https://github.com/pbreheny/ncvreg/issues}
}

}
\author{
\strong{Maintainer}: Patrick Breheny \email{patrick-breheny@uiowa.edu} (\href{https://orcid.org/0000-0002-0650-1119}{ORCID})

}
\keyword{internal}
