% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFAxisNumeric.R
\docType{class}
\name{CFAxisNumeric}
\alias{CFAxisNumeric}
\title{Numeric CF axis object}
\description{
This class represents a numeric axis. Its values are numeric.
This class is used for axes with numeric values but without further
knowledge of their nature. More specific classes descend from this class.
}
\section{Super classes}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{\link[ncdfCF:CFAxis]{ncdfCF::CFAxis}} -> \code{CFAxisNumeric}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{values}}{The values of the axis, usually a numeric vector.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{dimnames}}{(read-only) The coordinates of the axis as a numeric
vector, or labels for every axis element if they have been set.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFAxisNumeric-new}{\code{CFAxisNumeric$new()}}
\item \href{#method-CFAxisNumeric-print}{\code{CFAxisNumeric$print()}}
\item \href{#method-CFAxisNumeric-brief}{\code{CFAxisNumeric$brief()}}
\item \href{#method-CFAxisNumeric-range}{\code{CFAxisNumeric$range()}}
\item \href{#method-CFAxisNumeric-indexOf}{\code{CFAxisNumeric$indexOf()}}
\item \href{#method-CFAxisNumeric-sub_axis}{\code{CFAxisNumeric$sub_axis()}}
\item \href{#method-CFAxisNumeric-clone}{\code{CFAxisNumeric$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="label_set"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-label_set'><code>ncdfCF::CFAxis$label_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="peek"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-peek'><code>ncdfCF::CFAxis$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="shard"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-shard'><code>ncdfCF::CFAxis$shard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="time"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-time'><code>ncdfCF::CFAxis$time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="write"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-write'><code>ncdfCF::CFAxis$write()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$new(grp, nc_var, nc_dim, orientation, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grp}}{The group that contains the netCDF variable.}

\item{\code{nc_var}}{The netCDF variable that describes this instance.}

\item{\code{nc_dim}}{The netCDF dimension that describes the dimensionality.}

\item{\code{orientation}}{The orientation (\code{X}, \code{Y}, \code{Z}, or \code{T}) or \code{""} if
different or unknown.}

\item{\code{values}}{The dimension values of this axis.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-print"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-print}{}}}
\subsection{Method \code{print()}}{
Summary of the time axis printed to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed on to other functions. Of particular interest
is \verb{width = } to indicate a maximum width of attribute columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-brief"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-brief}{}}}
\subsection{Method \code{brief()}}{
Some details of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$brief()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 1-row \code{data.frame} with some details of the axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-range"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-range}{}}}
\subsection{Method \code{range()}}{
Retrieve the range of coordinate values in the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$range()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector with two elements with the minimum and maximum
values in the axis, respectively.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-indexOf"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-indexOf}{}}}
\subsection{Method \code{indexOf()}}{
Retrieve the indices of supplied values on the axis. If the
axis has bounds then the supplied values must fall within the bounds to
be considered valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$indexOf(x, method = "constant")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A numeric vector of values whose indices into the axis to
extract.}

\item{\code{method}}{Extract index values without ("constant", the default) or
with ("linear") fractional parts.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An integer vector giving the indices in \code{x} of valid values
provided, or \code{integer(0)} if none of the \code{x} values are valid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-sub_axis"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-sub_axis}{}}}
\subsection{Method \code{sub_axis()}}{
Return an axis spanning a smaller dimension range. This
method returns an axis which spans the range of indices given by the
\code{rng} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$sub_axis(group, rng = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{The group to create the new axis in.}

\item{\code{rng}}{The range of values from this axis to include in the returned
axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{CFAxisNumeric} instance covering the indicated range of
indices. If the \code{rng} argument includes only a single value, an
\link{CFAxisScalar} instance is returned with the value from this axis. If
the value of the argument is \code{NULL}, return the entire axis (possibly
as a scalar axis).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
