% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{nc.get.proj4.string}
\alias{nc.get.proj4.string}
\title{Gets the proj4 string for a file}
\usage{
nc.get.proj4.string(f, v)
}
\arguments{
\item{f}{The file (an object of class \code{ncdf4})}

\item{v}{The name of a variable}
}
\value{
A string containing the proj4 string, or NULL if a translator is not available for the given projection.
}
\description{
Gets the proj4 string for a file.
}
\details{
Most NetCDF files are stored without any projection information as a lat-long grid. However, some files -- particularly those from RCMs -- are on a projected grid. This function returns a proj4 string, suitable for use with the 'proj4' library, which can be used to perform forward and inverse projections.

Given a file and a variable, this function returns the proj4 string for the given file should be. If no projection data is found, it returns an empty string. It currently supports Lambert Conformal Conic, Transverse Mercator, Polar Sterographic, and Rotated Pole projections, plus the latitude_longitude pseudo-projection.
}
\examples{
## Get the proj4 string for a hypothetical file.
\dontrun{
f <- nc_open("pr.nc")
proj4.string <- nc.get.proj4.string(f, "pr")
nc_close(f)
}

}
\references{
\url{http://cfconventions.org/Data/cf-conventions/cf-conventions-1.8/cf-conventions.html#grid-mappings-and-projections}
}
