% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonbimatch.R
\name{nonbimatch}
\alias{nonbimatch}
\alias{nonbimatch,distancematrix-method}
\alias{nonbimatch-class}
\title{Nonbipartite Matching}
\usage{
nonbimatch(mdm, threshold = NA, precision = 6, ...)
}
\arguments{
\item{mdm}{A distancematrix object.  See the distancematrix function.}

\item{threshold}{An numeric value, indicating the distance needed to create
chameleon matches.}

\item{precision}{The largest value in the matrix will have at most this many
digits.  The default value is six.}

\item{\dots}{Additional arguments, these are not used.}
}
\value{
nonbimatch S4 object with several elements

 \item{matches}{data.frame containing matches}

 \item{halves}{data.frame containing each match}

 \item{total}{sum of the distances across all pairs}

 \item{mean}{mean distance for each pair}
}
\description{
The nonbinmatch function creates the set of pairwise matches that minimizes
the sum of distances between the pairs.
}
\details{
The nonbinmatch function calls the Fortran code (Derigs) and set of pairwise
matches that minimizes the sum of distances between the pairs.
}
\examples{

plainmatrix<-as.matrix(dist(sample(1:25, 8, replace=TRUE)))
diag(plainmatrix) <- 99999  # setting diagonal to an infinite distance for
                           # pedagogical reasons (the diagonal may be left
                           # as zero)
mdm<-distancematrix(plainmatrix)
res<-nonbimatch(mdm)

}
\author{
Cole Beck
}
\seealso{
\code{\link{distancematrix}}
}

