% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qnbconv.R
\name{qnbconv}
\alias{qnbconv}
\title{Calculates the quantile function for the convolution of arbitrary negative binomial random variables.}
\usage{
qnbconv(
  probs,
  counts,
  mus,
  ps,
  phis,
  method = c("exact", "moments", "saddlepoint"),
  n.terms = 1000,
  n.cores = 1,
  tolerance = 0.001,
  normalize = TRUE
)
}
\arguments{
\item{probs}{Vector of target (cumulative) probabilities.}

\item{counts}{Vector of counts over which the PMF is evaluated.}

\item{mus}{Vector of individual mean values}

\item{ps}{Vector of individual probabilities of success.}

\item{phis}{Vector of individual dispersion parameters. Equivalent to 'size' in dnbinom.}

\item{method}{The method by which to evaluate the PMF. One of "exact", "moments", or "saddlepoint".}

\item{n.terms}{The number of terms to include in the series for evaluating the PMF at a given number of counts. Defaults to 1000.}

\item{n.cores}{The number of CPU cores to use in the evaluation. Allows parallelization.}

\item{tolerance}{The acceptable difference between the sum of the K distribution and 1.}

\item{normalize}{Boolean. If TRUE, the PMF is normalized to sum to 1.}
}
\value{
A numeric vector of quantiles.
}
\description{
Calculates the quantile function for the convolution of arbitrary negative binomial random variables.
}
\examples{
qnbconv(probs = c(0.05, 0.25, 0.5, 0.75, 0.95), counts = 0:500,
       mus = c(100, 10), phis = c(5, 8), method = "exact")

}
