% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngraph.R
\name{spine}
\alias{spine}
\title{Compute the longest path (aka spine or backbone) of a neuron}
\usage{
spine(n, UseStartPoint = FALSE, SpatialWeights = TRUE, invert = FALSE,
  rval = c("neuron", "length", "ids"))
}
\arguments{
\item{n}{the neuron to consider.}

\item{UseStartPoint}{Whether to use the StartPoint of the neuron (often the 
soma) as the starting point of the returned spine.}

\item{SpatialWeights}{logical indicating whether spatial distances (default) 
should be used to weight segments instead of weighting each edge equally.}

\item{invert}{When \code{invert=TRUE} the spine is pruned away instead of 
being selected. This is only valid when \code{rval='neuron'} or
\code{rval='ids'}.}

\item{rval}{Character vector indicating the return type, one of 
\code{'neuron'}, \code{'length'} or \code{'ids'}. See \bold{Value} section.}
}
\value{
Either \itemize{
  
  \item a neuron object corresponding to the longest path \emph{or}
  
  \item the length of the longest path (when \code{rval="length"}) \emph{or}
  
  \item an integer vector of raw point indices (when \code{rval="ids"}).
  
  }
}
\description{
Compute the longest path (aka spine or backbone) of a neuron
}
\examples{
pn.spine=spine(Cell07PNs[[1]])
\donttest{
plot3d(Cell07PNs[[1]])
plot3d(pn.spine, lwd=4, col='black')
}
# just extract length
spine(Cell07PNs[[1]], rval='length')
# same result since StartPoint is included in longest path
spine(Cell07PNs[[1]], rval='length', UseStartPoint=TRUE)

# extract everything but the spine
antispine=spine(Cell07PNs[[1]], invert=TRUE)
\donttest{
plot3d(Cell07PNs[[1]])
plot3d(antispine, lwd=4, col='red')
}

}
\seealso{
\code{\link[igraph]{diameter}}, 
  \code{\link[igraph]{shortest.paths}}, \code{\link{prune_strahler}} for 
  removing lower order branches from a neuron, \code{\link{prune}} for 
  removing parts of a neuron by spatial criteria.

Other neuron: \code{\link{neuron}}, \code{\link{ngraph}},
  \code{\link{plot.neuron}},
  \code{\link{potential_synapses}}, \code{\link{prune}},
  \code{\link{resample}}, \code{\link{rootpoints}},
  \code{\link{subset.neuron}}
}

