% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HKnorm.R
\name{HKnorm}
\alias{HKnorm}
\title{Normalization to Housekeeping Genes}
\usage{
HKnorm(raw, is.logged = FALSE, corr = 1e-04)
}
\arguments{
\item{raw}{data frame of raw counts obtained from nCounter (rows represent
genes, columns represent samples). The first three columns must be labeled:
\code{c("Code.Class", "Name", "Accession")} and contain that information.}

\item{is.logged}{logical; If \code{TRUE}, normalization has already been done on
log base 2 scale, no need log the data}

\item{corr}{small correction to avoid error}
}
\value{
data frame of log normalized data in the same format but without
reference genes
}
\description{
Normalizes the gene expression of NanoString nCounter data to housekeeping
genes. This is done by subtracting the average log housekeeping gene
expression from the expression level of every gene in each sample.
}
\examples{
HKnorm(ovd.r)
HKnorm(ovd.r, is.logged = TRUE)
}
\author{
Aline Talhouk, Derek Chiu
}
