% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{collect_aio}
\alias{collect_aio}
\alias{collect_aio_}
\title{Collect Data of an Aio or List of Aios}
\usage{
collect_aio(x)

collect_aio_(x)
}
\arguments{
\item{x}{an Aio or list of Aios (objects of class \sQuote{sendAio},
\sQuote{recvAio} or \sQuote{ncurlAio}).}
}
\value{
Depending on the type of \sQuote{x} supplied, an object or list of
  objects (the same length as \sQuote{x}, preserving names).
}
\description{
\code{collect_aio} collects the data of an Aio or list of Aios, waiting for
resolution if still in progress.

\code{collect_aio_} is a variant that allows user interrupts, suitable for
interactive use.
}
\details{
This function will wait for the asynchronous operation(s) to complete if
still in progress (blocking).

Using \code{x[]} on an Aio \code{x} is equivalent to the user-interruptible
\code{collect_aio_(x)}.
}
\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
s2 <- socket("pair", dial = "inproc://nanonext")

res <- send_aio(s1, data.frame(a = 1, b = 2), timeout = 100)
collect_aio(res)

msg <- recv_aio(s2, timeout = 100)
collect_aio_(msg)

msg[]

close(s1)
close(s2)

}
