% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{recv_aio}
\alias{recv_aio}
\title{Receive Async}
\usage{
recv_aio(
  con,
  mode = c("serial", "character", "complex", "double", "integer", "logical", "numeric",
    "raw"),
  timeout = NULL,
  keep.raw = FALSE,
  n = 65536L
)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{mode}{[default 'serial'] mode of vector to be received - one of 'serial',
'character', 'complex', 'double', 'integer', 'logical', 'numeric', or 'raw'.
The default 'serial' means a serialised R object, for the other modes,
the raw vector received will be converted into the respective mode.
For Streams, 'serial' is not an option and the default is 'character'.
Alternatively, for performance, specify an integer position in the vector
of choices e.g. 1L for 'serial', 2L for 'character' etc.}

\item{timeout}{[default NULL] integer value in milliseconds or NULL, which
applies a socket-specific default, usually the same as no timeout.}

\item{keep.raw}{[default FALSE] logical flag whether to keep and return the
received raw vector along with the converted data. Supplying a non-logical
value will error.}

\item{n}{[default 65536L] applicable to Streams only, the maximum number of
bytes to receive. Can be an over-estimate, but note that a buffer of this
size is reserved.}
}
\value{
A 'recvAio' (object of class 'recvAio') (invisibly).
}
\description{
Receive data asynchronously over a connection (Socket, Context or Stream).
}
\details{
Async receive is always non-blocking and returns a 'recvAio'
    immediately.

    For a 'recvAio', the received message is available at \code{$data}, and
    the raw message at \code{$raw} (if kept). An 'unresolved' logical NA is
    returned if the async operation is yet to complete.

    To wait for the async operation to complete and retrieve the received
    message, use \code{\link{call_aio}} on the returned 'recvAio' object.

    Alternatively, to stop the async operation, use \code{\link{stop_aio}}.

    In case of an error, an integer 'errorValue' is returned (to be
    distiguishable from an integer message value). This can be verified using
    \code{\link{is_error_value}}.

    If the raw message was successfully received but an error occurred in
    unserialisation or data conversion (for example if the incorrect mode was
    specified), the received raw vector will be stored at \code{$data} to
    allow for the data to be recovered.
}
\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
s2 <- socket("pair", dial = "inproc://nanonext")

res <- send_aio(s1, data.frame(a = 1, b = 2), timeout = 100)
msg <- recv_aio(s2, timeout = 100)
msg
msg$data

res <- send_aio(s1, c(1.1, 2.2, 3.3), mode = "raw", timeout = 100)
msg <- recv_aio(s2, mode = "double", timeout = 100, keep.raw = TRUE)
msg
msg$raw
msg$data

res <- send_aio(s1, "example message", mode = "raw", timeout = 100)
msg <- recv_aio(s2, mode = "character", timeout = 100, keep.raw = TRUE)
call_aio(msg)
msg$raw
msg$data

close(s1)
close(s2)

}
