% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tls.R
\name{base64enc}
\alias{base64enc}
\alias{base64dec}
\title{Base64 Encode / Decode}
\usage{
base64enc(x, convert = TRUE)

base64dec(x, convert = TRUE)
}
\arguments{
\item{x}{an object.}

\item{convert}{For \strong{base64enc}: [default TRUE] logical TRUE to encode
to a character string or FALSE to a raw vector.\cr
For \strong{base64dec}: [default TRUE] logical TRUE to convert back to a
character string, FALSE to convert back to a raw vector or NA to decode
and then unserialize back to the original object.}
}
\value{
For \strong{base64enc}: A character string or raw vector depending on
    the value of 'convert'.

    For \strong{base64dec}: A character string, raw vector, or other object
    depending on the value of 'convert'.
}
\description{
Encodes / decodes a character string or arbitrary R object to base64 encoding.
}
\details{
For encoding: a character string or raw vector (with no attributes)
    is encoded 'as is', whilst all other objects are first serialized (using
    R serialisation version 3, big-endian representation).

    For decoding: the value of 'convert' should be set to TRUE, FALSE or NA
    to be the analogue of the above 3 cases in order to return the original
    object.
}
\examples{
base64enc("hello world!")
base64dec(base64enc("hello world!"))

base64enc(as.raw(c(1L, 2L, 4L)), convert = FALSE)
base64dec(base64enc(as.raw(c(1L, 2L, 4L))), convert = FALSE)

base64enc(data.frame())
base64dec(base64enc(data.frame()), convert = NA)

}
