% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/socket.R
\name{reap}
\alias{reap}
\title{Reap}
\usage{
reap(con)
}
\arguments{
\item{con}{a Socket, Context, Listener or Dialer.}
}
\value{
Invisibly, an integer exit code (zero on success).
}
\description{
A faster alternative to \code{close} for Sockets, Contexts, Listeners and
    Dialers avoiding S3 method dispatch.
}
\details{
May be used on unclassed external pointers e.g. those created by
    \code{\link{.context}}.
}
\examples{
s <- socket("req")
listen(s)
dial(s)
ctx <- .context(s)

reap(ctx)
reap(s[["dialer"]][[1]])
reap(s[["listener"]][[1]])
reap(s)

}
\seealso{
\code{\link{close}}
}
