% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{ctx_send}
\alias{ctx_send}
\title{Send over Context (Async)}
\usage{
ctx_send(context, ..., timeout)
}
\arguments{
\item{context}{a Context.}

\item{...}{one or more R objects to send (serialised) asynchronously.}

\item{timeout}{in ms. If unspecified, a socket-specific default timeout will
be used.}
}
\value{
A vector of zeros (invisibly) on success.
}
\description{
Send any number of R objects asynchronously over a Context, with the ability
    to set (optional) send timeouts. For sending and receiving within R -
    objects are sent serialized to ensure perfect reproducibility.
}
\details{
Will block if the send is in progress and has not yet completed -
    certain protocol / transport combinations may limit the number of messages
    that can be queued if they have yet to be received. Set a timeout to
    ensure the function returns under all conditions.
}
\examples{
req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctx <- context(req)
out <- ctx_send(ctx, data.frame(a = 1, b = 2), data.frame(c = 3, d = 4), timeout = 100)
out

close(req)
close(rep)

}
