% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array-stream.R
\name{array_stream_set_finalizer}
\alias{array_stream_set_finalizer}
\title{Register an array stream finalizer}
\usage{
array_stream_set_finalizer(array_stream, finalizer)
}
\arguments{
\item{array_stream}{A \link[=as_nanoarrow_array_stream]{nanoarrow_array_stream}}

\item{finalizer}{A function that will be called with zero arguments.}
}
\value{
\code{array_stream}, invisibly
}
\description{
In some cases, R functions that return a \link[=as_nanoarrow_array_stream]{nanoarrow_array_stream}
may require that the scope of some other object outlive that of the array
stream. If there is a need for that object to be released deterministically
(e.g., to close open files), you can register a function to run after the
stream's release callback is invoked from the R thread. Note that this
finalizer will \strong{not} be run if the stream's release callback is invoked
from a \strong{non}-R thread. In this case, the finalizer and its chain of
environments will be garbage-collected when \code{nanoarrow:::preserved_empty()}
is run.
}
\examples{
stream <- basic_array_stream(list(1:5))
array_stream_set_finalizer(stream, function() message("All done!"))
stream$release()

}
