% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brightness.R
\name{brightness_timeseries}
\alias{brightness_timeseries}
\title{Create a brightness time-series.}
\usage{
brightness_timeseries(
  img,
  def,
  frames_per_set,
  overlap = FALSE,
  thresh = NULL,
  detrend = FALSE,
  quick = FALSE,
  filt = NULL,
  s = 1,
  offset = 0,
  readout_noise = 0,
  parallel = FALSE
)
}
\arguments{
\item{img}{A 4-dimensional array in the style of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]})
or a 3-dimensional array which is a single channel of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, frame]}).}

\item{def}{A character. Which definition of brightness do you want to use,
\code{"B"} or \code{"epsilon"}?}

\item{frames_per_set}{The number of frames with which to calculate the
successive brightnesses.}

\item{overlap}{A boolean. If \code{TRUE}, the windows used to calculate number are
overlapped, if \code{FALSE}, they are not. For example, for a 20-frame image
series with 5 frames per set, if the windows are not overlapped, then the
frame sets used are 1-5, 6-10, 11-15 and 16-20; whereas if they are
overlapped, the frame sets are 1-5, 2-6, 3-7, 4-8 and so on up to 16-20.}

\item{thresh}{The threshold or thresholding method (see
\code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}}) to use on the image prior to
detrending and brightness calculations.}

\item{detrend}{Detrend your data with \code{\link[detrendr:img_detrend_rh]{detrendr::img_detrend_rh()}}. This is
the best known detrending method for brightness analysis. For more
fine-grained control over your detrending, use the \code{detrendr} package. If
there are many channels, this may be specified as a vector, one element for
each channel.}

\item{quick}{If \code{FALSE} (the default), the swap finding routine is run
several times to get a consensus for the best parameter. If \code{TRUE}, the
swap finding routine is run only once.}

\item{filt}{Do you want to smooth (\code{filt = 'mean'}) or median (\code{filt = 'median'}) filter the number image using \code{\link[=smooth_filter]{smooth_filter()}} or
\code{\link[=median_filter]{median_filter()}} respectively? If selected, these are invoked here with a
filter radius of 1 (with corners included, so each median is the median of
9 elements) and with the option \code{na_count = TRUE}. If you want to
smooth/median filter the number image in a different way, first calculate
the numbers without filtering (\code{filt = NULL}) using this function and then
perform your desired filtering routine on the result. If there are many
channels, this may be specified as a vector, one element for each channel.}

\item{s}{A positive number. The \eqn{S}-factor of microscope acquisition.}

\item{offset}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{readout_noise}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}
}
\value{
An object of class \link{brightness_ts_img}.

\itemize{\item If \code{img} is 3-dimensional (i.e. 1-channel), a 3-dimensional
array \code{arr} is returned with \code{arr[y, x, t]} being pixel \eqn{(x, y)} of the
\eqn{t}th brightness image in the brightness time series. \item If  \code{img}
is 4-dimensional (i.e. 2-channel), a 4-dimensional array \code{arr} is returned
with \code{arr[y, x, c, t]} being pixel \eqn{(x, y)} of the \eqn{c}th channel of
the \eqn{t}th brightness image in the brightness time series.}
}
\description{
Given a stack of images \code{img}, use the first \code{frames_per_set} of them to
create one brightness image, the next \code{frames_per_set} of them to create the
next brightness image and so on to get a time-series of brightness images.
}
\details{
This may discard some images, for example if 175 frames are in the input and
\code{frames_per_set = 50}, then the last 25 are discarded. If detrending is
selected, it is performed on the whole image stack before the sectioning is
done for calculation of numbers.
}
\examples{
\donttest{
img <- ijtiff::read_tif(system.file("extdata", "50.tif", package = "nandb"))
bts <- brightness_timeseries(img, "e", frames_per_set = 20, thresh = "Huang")
}
}
\seealso{
\code{\link[=brightness]{brightness()}}.
}
