# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Smooth and median filters with options for handling NAs.
#'
#' These are alternatives to
#' `EBImage::filter2()` and `EBImage::medianFilter()` for
#' smooth and median filtering respectively. These functions have many options
#' for dealing with \code{NA} values which \code{EBImage}'s functions lack.
#'
#' The behavior at image boundaries is such as the source image has been padded
#' with pixels whose values equal the nearest border pixel value.
#'
#' @param mat A matrix (representing an image).
#' @param size An integer; the median filter radius.
#' @param na_rm Should \code{NA}s be ignored?
#' @param na_count If this is TRUE, in each median calculation, if the majority
#' of arguments are \code{NA}s, \code{NA} is returned but if the \code{NA}s are
#' in the minority, they are ignored as in \code{median(x, na.rm = TRUE)}.
#'
#' @return A matrix (the median filtered image).
#'
#' @examples
#' m <- matrix(1:9, nrow = 3)
#' m[2:3, 2:3] <- NA
#' print(m)
#' median_filter(m)
#' median_filter(m, na_rm = TRUE)
#' median_filter(m, na_count = TRUE)
#'
#' @export
median_filter <- function(mat, size = 1L, na_rm = FALSE, na_count = FALSE) {
    .Call(`_nandb_median_filter`, mat, size, na_rm, na_count)
}

#' @rdname median_filter
#'
#' @examples
#' smooth_filter(m)
#' smooth_filter(m, na_rm = TRUE)
#' smooth_filter(m, na_count = TRUE)
#'
#' @export
smooth_filter <- function(mat, size = 1L, na_rm = FALSE, na_count = FALSE) {
    .Call(`_nandb_smooth_filter`, mat, size, na_rm, na_count)
}

cross_var_Cpp <- function(x, y) {
    .Call(`_nandb_cross_var_Cpp`, x, y)
}

cross_var_pillars_Cpp <- function(x3d, y3d) {
    .Call(`_nandb_cross_var_pillars_Cpp`, x3d, y3d)
}

float_max <- function() {
    .Call(`_nandb_float_max`)
}

which_interval_ <- function(numbers, ranges) {
    .Call(`_nandb_which_interval_`, numbers, ranges)
}

spread_specific_helper <- function(interval_lengths, interval_pops, m) {
    .Call(`_nandb_spread_specific_helper`, interval_lengths, interval_pops, m)
}

