% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{FixLUTError}
\alias{FixLUTError}
\title{Fix lookup table error when reading images.}
\usage{
FixLUTError(arr, ndim.out)
}
\arguments{
\item{arr}{An array, representing the read image.}

\item{ndim.out}{How many dimensions do you want the output array to have?}
}
\value{
An array. If the function implemented a 'fix', then the output array
will have one less dimension than the input array.
}
\description{
Even if an image stored on disk has 1 channel only, if it has an associated
LUT (lookup table, to tell programs like ImageJ to display them in (for
example) green rather than grey, then \code{\link[EBImage:readImage]{EBImage::readImage()}} and
hence \code{\link[=ReadImageData]{ReadImageData()}} will read in the image as a 3-channel rgb
colour image, where two of the channels have all-zero intensity values and
one of them has the values you wanted. This function deletes the zero
channels from the array. If there were no such LUT errors and the image read
in as you desired, then this function does nothing.
}
\examples{
has.lut.error <- abind::abind(matrix(0, nrow = 2, ncol = 2),
                              matrix(1:4, nrow = 2),
                              matrix(0, nrow = 2, ncol = 2),
                              along = 3)
has.lut.error
FixLUTError(has.lut.error, 2)
has.lut.error3d <- abind::abind(has.lut.error, has.lut.error, along = 4)
FixLUTError(has.lut.error3d, 3)
}
