% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number.R
\name{Number}
\alias{Number}
\alias{NumberTxtFolder}
\alias{Numbers}
\title{Calculate number from image series.}
\usage{
Number(arr, tau = NA, mst = NULL, filt = NULL, n.ch = 1,
  verbose = FALSE)

NumberTxtFolder(folder.path = ".", tau = NA, mst = NULL, filt = NULL,
  ext = "tif", mcc = parallel::detectCores(), seed = NULL,
  verbose = FALSE)

Numbers(arr3d.list, tau = NA, mst = NULL, fail = NA, filt = NULL,
  verbose = FALSE, mcc = parallel::detectCores(), seed = NULL)
}
\arguments{
\item{arr}{A 3-dimensional array (the image stack) where the \eqn{n}th
slice is the \eqn{n}th image in the time series. To perform this on a file
that has not yet been read in, set this argument to the path to that file
(a string).}

\item{tau}{If this is specified, bleaching correction is performed with
\code{\link[=CorrectForBleaching]{CorrectForBleaching()}} which uses exponential filtering with
time constant \code{tau} (where the unit of time is the time between
frames). If this is set to \code{'auto'}, then the value of \code{tau} is
calculated automatically via \code{\link[=BestTau]{BestTau()}}.}

\item{mst}{Do you want to apply an intensity threshold prior to calculating
number (via \code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}})? If so, set your thresholding
\emph{method} here.}

\item{filt}{Do you want to smooth (\code{filt = 'smooth'}) or median
(\code{filt = 'median'}) filter the number image using
\code{\link[=SmoothFilterB]{SmoothFilterB()}} or \code{\link[=MedianFilterB]{MedianFilterB()}} respectively? If
selected, these are invoked here with a filter radius of 1 and with the
option \code{na_count = TRUE}. If you want to smooth/median filter the
number image in a different way, first calculate the numbers without
filtering (\code{filt = NULL}) using this function and then perform your
desired filtering routine on the result.}

\item{n.ch}{The number of channels in the image (default 1).}

\item{verbose}{If arr3d is specified as a file name, print a message to tell
the user that that file is now being processed (useful for
\code{NumberTxtFolder}, does not work with multiple cores).}

\item{folder.path}{The path (relative or absolute) to the folder you wish to
process.}

\item{ext}{The file extension of the images in the folder that you wish to
process. You must wish to process all files with this extension; if there
are files that you don't want to process, take them out of the folder. The
default is for tiff files. Do not use regular expression in this argument.}

\item{mcc}{The number of cores to use for the parallel processing.}

\item{seed}{A seed for the random number generation for \link{BestTau}. Don't use
\link{set.seed}, it won't work.}

\item{arr3d.list}{A list of 3-dimensional arrays. To perform this on files
that have not yet been read in, set this argument to the path to these
files (a character vector).}

\item{fail}{If thresholding is done, to which value should pixels not
exceeeding the threshold be set?}
}
\value{
\code{Number} returns a matrix, the number image; \code{Numbers}
returns a list of these. The result of \code{NumberTxtFolder} is the text
csv files written to disk (in the same folder as the input images).
}
\description{
Given a time stack of images, \code{Number} performs a calculation of the
number for each pixel. \code{NumberTxtFolder} does this
calculation for an entire folder, writing the results as text files via
\code{\link[=WriteImageTxt]{WriteImageTxt()}}. \code{Numbers} calculates the numbers for
several image series in parallel.
}
\details{
Do not try to parallelize the use of \code{Number} and friends yourself (e.g.
with \code{\link[=mclapply]{mclapply()}}) because it will throw an error (this is because
the \code{autothresholdr} package does not work in parallel (indeed anything
run using the \code{rJava} package won't)). Always use \code{Numbers} for
this purpose (this has a workaround whereby it does the thresholding in
series and does the rest in parallel).
}
\examples{
library(EBImage)
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
display(normalize(img[, , 1]), method = 'raster')
number <- Number(img, tau = NA, mst = "Huang")
setwd(tempdir())
WriteIntImage(img, '50.tif')
WriteIntImage(img, '50again.tif')
NumberTxtFolder(tau = NA, mst = "Huang", mcc = 2)
file.remove(list.files())  # cleanup
img.paths <- rep(system.file('extdata', '50.tif', package = 'nandb'), 2)
numbers <- Numbers(img.paths, mst = 'otsu', mcc = 2)

}
