% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brightness.R
\name{Brightness}
\alias{Brightness}
\alias{BrightnessTxtFolder}
\alias{Brightnesses}
\title{Calculate brightness from image series.}
\usage{
Brightness(arr, tau = NA, mst = NULL, filt = NULL, n.ch = 1,
  verbose = FALSE)

BrightnessTxtFolder(folder.path = ".", tau = NA, mst = NULL,
  filt = NULL, ext = "tif", n.ch = 1, mcc = parallel::detectCores(),
  verbose = FALSE, seed = NULL)

Brightnesses(arr3d.list, tau = NA, mst = NULL, filt = NULL, n.ch = 1,
  verbose = FALSE, mcc = parallel::detectCores(), seed = NULL)
}
\arguments{
\item{arr}{An array, can be 3- or 4-dimensional. The first two slots give the
x- and y-cordinates of pixels respectively. If the array is 3-dimensional,
the third slot gives the index of the frame. If it is 4-dimensional, the
third slot indexes the channel and the fourth indexes the frame in the
stack. To perform this on a file that has not yet been read in, set this
argument to the path to that file (a string).}

\item{tau}{If this is specified, bleaching correction is performed with
\code{\link[=CorrectForBleaching]{CorrectForBleaching()}} which uses exponential filtering with
time constant \code{tau} (where the unit of time is the time between
frames). If this is set to \code{'auto'}, then the value of \code{tau} is
calculated automatically via \code{\link[=BestTau]{BestTau()}}.}

\item{mst}{Do you want to apply an intensity threshold prior to calculating
brightness (via \code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}})? If so, set your
thresholding \emph{method} here.}

\item{filt}{Do you want to smooth (\code{filt = 'smooth'}) or median
(\code{filt = 'median'}) filter the brightness image using
\code{\link[=SmoothFilterB]{SmoothFilterB()}} or \code{\link[=MedianFilterB]{MedianFilterB()}} respectively? If
selected, these are invoked here with a filter radius of 1 and with the
option \code{na_count = TRUE}. If you want to smooth/median filter the
brightness image in a different way, first calculate the brightnesses
without filtering (\code{filt = NULL}) using this function and then perform
your desired filtering routine on the result.}

\item{n.ch}{The number of channels in the image (default 1).}

\item{verbose}{If arr3d is specified as a file name, print a message to tell
the user that that file is now being processed (useful for
\code{BrightnessTxtFolder}, does not work with multiple cores).}

\item{folder.path}{The path (relative or absolute) to the folder you wish to
process.}

\item{ext}{The file extension of the images in the folder that you wish to
process. You must wish to process all files with this extension; if there
are files that you don't want to process, take them out of the folder. The
default is for tiff files. Do not use regular expression in this argument.}

\item{mcc}{The number of cores to use for the parallel processing.}

\item{seed}{A seed for the random number generation for \link{BestTau}. Don't use
\link{set.seed}, it won't work.}

\item{arr3d.list}{A list of 3-dimensional arrays. To perform this on files
that have not yet been read in, set this argument to the path to these
files (a character vector).}
}
\value{
\code{Brightness} returns a matrix, the brightness image;
\code{Brightnesses} returns a list of these. The result of
\code{BrightnessTxtFolder} is the text csv files written to disk (in the
same folder as the input images).
}
\description{
Given a time stack of images, \code{Brightness} performs a calculation of the
brightness for each pixel. \code{BrightnessTxtFolder} does this calculation
for an entire folder, writing the results as text files via
\code{\link[=WriteImageTxt]{WriteImageTxt()}}. \code{Brightnesses} calculates the brightnesses
for several image series in parallel.
}
\details{
Do not try to parallelize the use of \code{Brightness} and friends yourself
(e.g. with \code{\link[=mclapply]{mclapply()}}) because it will throw an error (this is
because the \code{autothresholdr} package does not work in parallel (indeed
anything run using the \code{rJava} package won't)). Always use
\code{Brightnesses} for this purpose (this has a workaround whereby it does
the thresholding in series and does the rest in parallel).
}
\examples{
library(magrittr)
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
EBImage::display(EBImage::normalize(img[, , 1]), method = 'raster')
brightness <- Brightness(img, tau = "auto", mst = 'Huang', filt = 'median')
MatrixRasterPlot(brightness, log.trans = TRUE)
two.channel.img <- abind::abind(img, img, along = 4) \%>\% aperm(c(1, 2, 4, 3))
brightness.2ch <- Brightness(two.channel.img, n.ch = 2)
setwd(tempdir())
WriteIntImage(img, '50.tif')
WriteIntImage(img, '50again.tif')
BrightnessTxtFolder(tau = NA, mcc = 2)
list.files()
file.remove(list.files())  # cleanup
img.paths <- rep(system.file('extdata', '50.tif', package = 'nandb'), 2)
brightnesses <- Brightnesses(img.paths, tau = NA, mcc = 2)

}
