% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StaPLR.R
\name{coef.StaPLR}
\alias{coef.StaPLR}
\title{Extract coefficients from a "StaPLR" object.}
\usage{
\method{coef}{StaPLR}(object, cvlambda = "lambda.min", ...)
}
\arguments{
\item{object}{Fitted "StaPLR" model object.}

\item{cvlambda}{By default, the coefficients are extracted at the CV-optimal values of the penalty parameters. Choosing "lambda.1se" will extract them at the largest values within one standard error of the minima.}

\item{...}{Further arguments to be passed to \code{\link[glmnet]{coef.cv.glmnet}}.}
}
\value{
An object with S3 class "StaPLRcoef".
}
\description{
Extract base- and meta-level coefficients from a "StaPLR" object at the CV-optimal values of the penalty parameters.
}
\examples{
\donttest{
set.seed(012)
n <- 1000
cors <- seq(0.1,0.7,0.1)
X <- matrix(NA, nrow=n, ncol=length(cors)+1)
X[,1] <- rnorm(n)

for(i in 1:length(cors)){
  X[,i+1] <- X[,1]*cors[i] + rnorm(n, 0, sqrt(1-cors[i]^2))
}

beta <- c(1,0,0,0,0,0,0,0)
eta <- X \%*\% beta
p <- exp(eta)/(1+exp(eta))
y <- rbinom(n, 1, p)
view_index <- rep(1:(ncol(X)/2), each=2)

fit <- StaPLR(X, y, view_index)
coef(fit)$meta

new_X <- matrix(rnorm(16), nrow=2)
predict(fit, new_X)}
}
\author{
Wouter van Loon <w.s.van.loon@fsw.leidenuniv.nl>
}
\keyword{TBA}
