% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{mardia}
\alias{mardia}
\title{Mardia Test (Skewness and Kurtosis) for Multivariate Normality}
\usage{
mardia(X, std = TRUE)
}
\arguments{
\item{X}{an \eqn{n*p} numeric matrix or data frame.}

\item{std}{if \code{TRUE}, the data matrix or data frame will be standardized via normalizing
the covariance matrix by \eqn{n}.}
}
\value{
Returns a list with two objects:
\describe{
\item{\code{mv.test}}{results of the Mardia test, i.e., test statistic, \emph{p}-value, and multivariate normality summary (YES, if both skewness and kurtosis \emph{p}-value>0.05).}
\item{\code{uv.shapiro}}{a dataframe with \eqn{p} rows detailing univariate Shapiro-Wilk tests. Columns in the dataframe contain test statistics \emph{W}, \emph{p}-value,and univariate normality summary (YES, if \emph{p}-value>0.05).}
}
}
\description{
It computes Mardia (1970)'s multivariate skewness and kurtosis statistics and their corresponding
 p-value. Both p-values of skewness and kurtosis statistics should be greater than 0.05 to conclude
 multivariate normality. The skewness statistic will be adjusted for sample size \eqn{n < 20}.
}
\examples{
set.seed(12345)

## Data from gamma distribution
X = matrix(rgamma(50*4,shape =  2),50)
mardia(X)

## Data from normal distribution
X = matrix(rnorm(50*4,mean = 2 , sd = 1),50)
mardia(X)

## load the ubiquitous multivariate iris data ##
## (first 50 observations of columns 1:4) ##
iris.df = iris[1:50, 1:4]
mardia(iris.df)

}
\references{
Mardia, K. V. (1970). Measures of multivariate skewness and kurtosis with applications. \emph{Biometrika}, 57(3), 519-530.

Shapiro, S. S., & Wilk, M. B. (1965). An analysis of variance test for normality (complete samples). \emph{Biometrika}, 52(3/4), 591-611.

Doornik, J. A., & Hansen, H. (2008). An omnibus test for univariate and multivariate normality. \emph{Oxford Bulletin of Economics and Statistics}, 70, 927-939.

Zhou, M., & Shao, Y. (2014). A powerful test for multivariate normality. \emph{Journal of applied statistics}, 41(2), 351-363.
}
\seealso{
\code{\link{mvnTest}}, \code{\link{faTest}}, \code{\link{msw}}, \code{\link{msk}}, \code{\link{mhz}}, \code{\link{mvn}}
}
