% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{copulas}
\alias{copulas}
\title{Random Generation for the Copula Generated Distributions}
\usage{
copulas(n, p, c = "clayton", param, invF, ...)
}
\arguments{
\item{n}{number of rows (observations).}

\item{p}{total number of columns (variables).}

\item{c}{name of an Archimedean copula, choosing from "\code{clayton}" (default), "\code{frank}", or "\code{gumbel}".}

\item{param}{number (numeric) specifying the copula parameter.}

\item{invF}{inverse function (quantile function, e.g. \code{qnorm}).}

\item{...}{optional arguments passed to \code{invF}.}
}
\value{
univariate (\eqn{p=1}) or multivariate (\eqn{p>1}) random sample.
}
\description{
Generate univariate or multivariate random sample for the Copula Generated Distributions.
}
\examples{
set.seed(12345)

## Generate 5X2 random sample matrix from Clayton(0.5, qnorm) ##
copulas(n=50, p=2, c="clayton", param=0.5, invF=qnorm)


## Power calculation against bivariate (p=2) Clayton(0.5, qnorm) distribution ##
## at sample size n=50 at one-sided alpha = 0.05 ##

# Zhou-Shao's test #
power.mvnTest(a=0.05, n=50, p=2, B=100, FUN=copulas, c="clayton", param=0.5, invF=qnorm)

}
\references{
Yan, J. (2007). Enjoy the joy of copulas: with a package copula. \emph{Journal of Statistical Software}, 21(4), 1-21.
}
