% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trends.R
\name{mvgam_trends}
\alias{mvgam_trends}
\title{Supported mvgam trend models}
\description{
Supported mvgam trend models
}
\details{
\code{mvgam} currently supports the following dynamic trend models:
\itemize{
\item \code{None} (no latent trend component; i.e. the GAM component is all that contributes to the linear predictor,
and the observation process is the only source of error; similarly to what is estimated by \code{\link[mgcv]{gam}})
\item \code{RW()}
\item \verb{AR(p = 1, 2, or 3)}
\item \code{CAR(p = 1)}(continuous time autoregressive trends; only available in \code{Stan})
\item \code{VAR()}(only available in \code{Stan})
\item \code{PW()} (piecewise linear or logistic trends; only available in \code{Stan})
\item \code{GP()} (Gaussian Process with squared exponential kernel;
only available in \code{Stan})}

For most dynamic trend types available in \code{mvgam} (see argument \code{trend_model}), time should be
measured in discrete, regularly spaced intervals (i.e. \code{c(1, 2, 3, ...)}). However you can
use irregularly spaced intervals if using \code{trend_model = CAR(1)}, though note that any
temporal intervals that are exactly \code{0} will be adjusted to a very small number
(\code{1e-12}) to prevent sampling errors. For all trend types
apart from \code{GP()}, \code{PW()}, and \code{CAR()}, moving average and/or correlated
process error terms can also be estimated (for example, \code{RW(cor = TRUE)} will set up a
multivariate Random Walk if \code{data} contains \verb{>1} series). Character strings can also be supplied
instead of the various trend functions. The full list of possible models that are
currently supported is:
\itemize{
\item 'RW'
\item 'RWMA'
\item 'RWcor'
\item 'RWMAcor'
\item 'AR1'
\item 'AR1MA'
\item 'AR1cor'
\item 'AR1MAcor'
\item 'AR2'
\item 'AR2MA'
\item 'AR2cor'
\item 'AR2MAcor'
\item 'AR3'
\item 'AR3MA'
\item 'AR3cor'
\item 'AR3MAcor'
\item 'CAR1'
\item 'VAR'
\item 'VARcor'
\item 'VAR1' (same as 'VAR')
\item 'VAR1cor' (same as 'VARcor')
\item 'VARMA'
\item 'VARMAcor'
\item 'VARMA1,1cor'
\item 'PWlinear'
\item 'PWlogistic'
\item 'GP'
\item 'None'
}

Note that only \code{RW}, \code{AR1}, \code{AR2} and \code{AR3} are available if
using \code{JAGS}. All trend models are supported if using \code{Stan}.
Dynamic factor models can be used in which the latent factors evolve as either
\code{RW}, \code{AR1-3}, \code{VAR} or \code{GP}. For \code{VAR} models
(i.e. \code{VAR} and \code{VARcor} models), users can either fix the trend error covariances to be \code{0}
(using \code{VAR}) or estimate them and potentially allow for contemporaneously correlated errors using
\code{VARcor}. For all \code{VAR} models, stationarity of
the latent process is enforced through the prior using the parameterisation given by
Heaps (2022). Stationarity is not enforced when using \code{AR1}, \code{AR2} or \code{AR3} models,
though this can be changed by the user by specifying lower and upper bounds on autoregressive
parameters using functionality in \link{get_mvgam_priors} and the \code{priors} argument in
\link{mvgam}. Piecewise trends follow the formulation in the popular \code{prophet} package produced
by \code{Facebook}, where users can allow for changepoints to control the potential flexibility
of the trend. See Taylor and Letham (2018) for details
}
\references{
Sarah E. Heaps (2022) Enforcing stationarity through the prior in Vector Autoregressions.
Journal of Computational and Graphical Statistics. 32:1, 1-10.

Sean J. Taylor and Benjamin Letham (2018) Forecasting at scale.
The American Statistician 72.1, 37-45.
}
\seealso{
\code{\link{RW}}, \code{\link{AR}}, \code{\link{CAR}},
\code{\link{VAR}}, \code{\link{PW}}, \code{\link{GP}}
}
