% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rBrownResnick.R
\name{simulBrownResnick}
\alias{simulBrownResnick}
\title{Simulation of Brown--Resnick random vectors}
\usage{
simulBrownResnick(n, loc, vario, nCores = 1, cl = NULL)
}
\arguments{
\item{n}{Number of replicates desired.}

\item{loc}{Matrix of coordinates as given by \code{expand.grid()}.}

\item{vario}{Semi-variogram function.}

\item{nCores}{Number of cores needed for the computation}

\item{cl}{Cluster instance as created by \code{makeCluster} of the \code{parallel} package. Make sure
the random number generator has been properly initialized with
\code{clusterSetRNGStream()}.}
}
\value{
List of \code{n} random vectors drawn from a max-stable Brown--Resnick process
 with semi-variogram \code{vario} at location \code{loc}.
}
\description{
\code{simulBrownResnick} provides \code{n} replicates of a Brown--Resnick max-stable process with semi-variogram \code{vario}
at locations \code{loc}.
}
\details{
The algorithm used here is based on the spectral representation of the Brown--Resnick
model as described in Dombry et al. (2015). It provides \code{n} exact simulations
on the unit Frechet scale and requires, in average, for each max-stable vector, the simulation of d Pareto processes,
where d is the number of locations.
}
\examples{
#Define semi-variogram function
vario <- function(h){
   1 / 2 * norm(h,type = "2")^1.5
}

#Define locations
loc <- expand.grid(1:4, 1:4)

#Simulate data
obs <- simulBrownResnick(10, loc, vario)
}
