/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.rosuda.REngine.REXPDouble;
import test.REXPDouble3;

public class SerializationTest
implements Serializable {
    REXPDouble3 value;

    SerializationTest(REXPDouble3 value) {
        this.value = value;
    }

    public String toString() {
        double[] doubles = this.value.asDoubles();
        return doubles[0] + " : " + Double.doubleToRawLongBits(doubles[0]) + " : " + REXPDouble.isNA((double)doubles[0]) + " : " + REXPDouble.NA;
    }

    public void write(String filename) {
        File f = new File(filename);
        try {
            ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(f));
            stream.writeObject(this);
            stream.close();
        }
        catch (IOException e) {
            System.out.println(" erreur :" + e.toString());
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        File f = new File(filename);
        try {
            ObjectInputStream stream = new ObjectInputStream(new FileInputStream(f));
            SerializationTest data = (SerializationTest)stream.readObject();
            this.value = data.value;
            stream.close();
        }
        catch (Exception e) {
            System.out.println(" erreur :" + e.toString());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        REXPDouble rd = new REXPDouble(REXPDouble.NA);
        System.out.println(SerializationTest.isNA(rd.asDoubles()[0]));
        rd = new REXPDouble(Double.longBitsToDouble(9218868437227407266L));
        System.out.println(SerializationTest.isNA(rd.asDoubles()[0]));
        rd = new REXPDouble(Double.NaN);
        System.out.println(SerializationTest.isNA(rd.asDoubles()[0]));
    }

    public static void test(SerializationTest x) {
        System.out.println("before serialization : " + x);
        x.write("c:/x");
        x.read("c:/x");
        System.out.println("after serialization  : " + x + "\n");
    }

    public static boolean isNA(double value) {
        return Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(REXPDouble.NA);
    }
}

