/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.javaGD;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import org.rosuda.javaGD.GDCanvas;
import org.rosuda.javaGD.GDCircle;
import org.rosuda.javaGD.GDColor;
import org.rosuda.javaGD.GDFill;
import org.rosuda.javaGD.GDFont;
import org.rosuda.javaGD.GDLine;
import org.rosuda.javaGD.GDLinePar;
import org.rosuda.javaGD.GDPolygon;
import org.rosuda.javaGD.GDRect;
import org.rosuda.javaGD.GDText;

public class XGDserver
extends Thread {
    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(1427);
            while (true) {
                Socket socket = serverSocket.accept();
                System.out.println("Accepted connection, spawning new worker thread.");
                XGDworker xGDworker = new XGDworker();
                xGDworker.s = socket;
                xGDworker.start();
                xGDworker = null;
            }
        }
        catch (Exception exception) {
            System.out.println("XGDserver, exception: " + exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public static XGDserver startServer() {
        XGDserver xGDserver = new XGDserver();
        xGDserver.start();
        return xGDserver;
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting XGDserver.");
        XGDserver.startServer();
    }

    class XGDworker
    extends Thread {
        public Socket s;
        boolean isBE;
        GDCanvas c;
        Frame f;

        XGDworker() {
        }

        int getInt(byte[] byArray, int n) {
            return this.isBE ? byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n] & 0xFF) << 24 : byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }

        long getLong(byte[] byArray, int n) {
            long l;
            long l2;
            if (this.isBE) {
                l2 = (long)this.getInt(byArray, n + 4) & 0xFFFFFFFFL;
                l = (long)this.getInt(byArray, n) & 0xFFFFFFFFL;
            } else {
                l2 = (long)this.getInt(byArray, n) & 0xFFFFFFFFL;
                l = (long)this.getInt(byArray, n + 4) & 0xFFFFFFFFL;
            }
            return l2 | l << 32;
        }

        double getDouble(byte[] byArray, int n) {
            return Double.longBitsToDouble(this.getLong(byArray, n));
        }

        void setInt(int n, byte[] byArray, int n2) {
            if (!this.isBE) {
                byArray[n2] = (byte)(n & 0xFF);
                byArray[++n2] = (byte)((n & 0xFF00) >> 8);
                byArray[++n2] = (byte)((n & 0xFF0000) >> 16);
                byArray[++n2] = (byte)((n & 0xFF000000) >> 24);
            } else {
                byArray[n2 + 3] = (byte)(n & 0xFF);
                byArray[n2 + 2] = (byte)((n & 0xFF00) >> 8);
                byArray[n2 + 1] = (byte)((n & 0xFF0000) >> 16);
                byArray[n2] = (byte)((n & 0xFF000000) >> 24);
            }
        }

        void setLong(long l, byte[] byArray, int n) {
            this.setInt((int)(l & 0xFFFFFFFFL), byArray, this.isBE ? n + 4 : n);
            this.setInt((int)(l >> 32), byArray, this.isBE ? n : n + 4);
        }

        void setDouble(double d, byte[] byArray, int n) {
            this.setLong(Double.doubleToLongBits(d), byArray, n);
        }

        void dump(String string, byte[] byArray) {
            System.out.print(string);
            for (int i = 0; i < byArray.length; ++i) {
                System.out.print(Integer.toString(byArray[i], 16) + " ");
            }
            System.out.println("");
        }

        public void run() {
            try {
                this.s.setTcpNoDelay(true);
                System.out.println("XGDworker started with socket " + this.s);
                InputStream inputStream = this.s.getInputStream();
                OutputStream outputStream = this.s.getOutputStream();
                byte[] byArray = new byte[16];
                int n = inputStream.read(byArray);
                if (n != 16) {
                    System.out.println("Required 16 bytes, but got " + n + ". Invalid protocol.");
                    this.s.close();
                    return;
                }
                if (byArray[0] == 88 && byArray[1] == 71 && byArray[2] == 68) {
                    System.out.println("Connected to XGD version " + (byArray[3] - 48) + " on PPC-endian machine");
                    this.isBE = true;
                } else if (byArray[3] == 88 && byArray[2] == 71 && byArray[1] == 68) {
                    System.out.println("Connected to XGD version " + (byArray[0] - 48) + " on Intel-endian machine");
                    this.isBE = false;
                } else {
                    System.out.println("Unknown protocol, bailing out");
                    this.s.close();
                    return;
                }
                byte[] byArray2 = new byte[4];
                while (true) {
                    FontMetrics fontMetrics;
                    Graphics graphics;
                    Serializable serializable;
                    double d;
                    int n2;
                    if ((n = inputStream.read(byArray2)) < 4) {
                        System.out.println("Needed 4 bytes, got " + n);
                        break;
                    }
                    int n3 = this.getInt(byArray2, 0);
                    int n4 = n3 & 0xFF;
                    System.out.println("CMD: " + byArray2[3] + ", length: " + (n3 >>= 8));
                    byte[] byArray3 = new byte[n3];
                    if (n3 > 0 && (n2 = inputStream.read(byArray3)) != n3) {
                        System.out.println("Needed " + n3 + " bytes, got " + n2);
                        break;
                    }
                    if (n4 == 1) {
                        double d2 = this.getDouble(byArray3, 0);
                        d = this.getDouble(byArray3, 8);
                        System.out.println("Open(" + d2 + ",+" + d + ")");
                        if (this.f != null) {
                            this.f.removeAll();
                            this.f.dispose();
                            this.f = null;
                            if (this.c != null) {
                                this.c = null;
                            }
                        }
                        this.f = new Frame();
                        this.c = new GDCanvas((int)d2, (int)d);
                        this.f.add(this.c);
                        this.f.pack();
                        this.f.setVisible(true);
                    }
                    if (n4 == 2) {
                        if (this.f != null) {
                            this.f.removeAll();
                            this.f.dispose();
                            this.f = null;
                            if (this.c != null) {
                                this.c = null;
                            }
                        }
                        System.out.println("Device closed.");
                        return;
                    }
                    if (n4 == 9 && this.c != null) {
                        this.c.add(new GDLine(this.getDouble(byArray3, 0), this.getDouble(byArray3, 8), this.getDouble(byArray3, 16), this.getDouble(byArray3, 24)));
                    }
                    if (n4 == 15 && this.c != null) {
                        this.c.add(new GDRect(this.getDouble(byArray3, 0), this.getDouble(byArray3, 8), this.getDouble(byArray3, 16), this.getDouble(byArray3, 24)));
                    }
                    if (n4 == 5 && this.c != null) {
                        this.c.add(new GDCircle(this.getDouble(byArray3, 0), this.getDouble(byArray3, 8), this.getDouble(byArray3, 16)));
                    }
                    if (n4 == 11 && this.c != null && this.getInt(byArray3, 0) == 0) {
                        this.c.repaint();
                    }
                    if (n4 == 12 && this.c != null) {
                        this.c.reset();
                    }
                    if ((n4 == 13 || n4 == 14) && this.c != null) {
                        n2 = this.getInt(byArray3, 0);
                        double[] dArray = new double[n2];
                        double[] dArray2 = new double[n2];
                        for (int i = 0; i < n2; ++i) {
                            dArray[i] = this.getDouble(byArray3, 4 + i * 8);
                            dArray2[i] = this.getDouble(byArray3, 4 + i * 8 + n2 * 8);
                        }
                        this.c.add(new GDPolygon(n2, dArray, dArray2, n4 == 14));
                    }
                    if (n4 == 18 && this.c != null) {
                        this.c.add(new GDText(this.getDouble(byArray3, 0), this.getDouble(byArray3, 8), this.getDouble(byArray3, 16), this.getDouble(byArray3, 24), new String(byArray3, 32, byArray3.length - 33)));
                    }
                    if (n4 == 19 && this.c != null) {
                        this.c.add(new GDColor(this.getInt(byArray3, 0)));
                    }
                    if (n4 == 20 && this.c != null) {
                        this.c.add(new GDFill(this.getInt(byArray3, 0)));
                    }
                    if (n4 == 21 && this.c != null) {
                        GDFont gDFont = new GDFont(this.getDouble(byArray3, 0), this.getDouble(byArray3, 8), this.getDouble(byArray3, 16), this.getInt(byArray3, 24), new String(byArray3, 32, byArray3.length - 33));
                        this.c.add(gDFont);
                        this.c.gs.f = gDFont.font;
                    }
                    if (n4 == 22 && this.c != null) {
                        this.c.add(new GDLinePar(this.getDouble(byArray3, 0), this.getInt(byArray3, 8)));
                    }
                    if (n4 == 80) {
                        byte[] byArray4 = new byte[36];
                        this.setInt(8400, byArray4, 0);
                        double d3 = 0.0;
                        double d4 = 0.0;
                        if (this.c != null) {
                            serializable = this.c.getSize();
                            d3 = ((Dimension)serializable).getWidth();
                            d4 = ((Dimension)serializable).getHeight();
                        }
                        this.setDouble(0.0, byArray4, 4);
                        this.setDouble(d3, byArray4, 12);
                        this.setDouble(d4, byArray4, 20);
                        this.setDouble(0.0, byArray4, 28);
                        outputStream.write(byArray4);
                        outputStream.flush();
                    }
                    if (n4 == 81) {
                        Graphics graphics2;
                        String string = new String(byArray3, 0, byArray3.length - 1);
                        System.out.println("Request: get string width of \"" + string + "\"");
                        byte[] byArray5 = new byte[12];
                        this.setInt(2257, byArray5, 0);
                        d = 8 * string.length();
                        if (this.c != null && (graphics2 = this.c.getGraphics()) != null && (serializable = graphics2.getFontMetrics(this.c.gs.f)) != null) {
                            d = ((FontMetrics)serializable).stringWidth(string);
                        }
                        System.out.println(">> WIDTH: " + d);
                        this.setDouble(d, byArray5, 4);
                        outputStream.write(byArray5);
                        outputStream.flush();
                    }
                    if (n4 != 74) continue;
                    int n5 = this.getInt(byArray3, 0);
                    System.out.println("Request: metric info for char " + n5);
                    byte[] byArray6 = new byte[28];
                    d = 0.0;
                    double d5 = 0.0;
                    double d6 = 8.0;
                    if (this.c != null && (graphics = this.c.getGraphics()) != null && (fontMetrics = graphics.getFontMetrics(this.c.gs.f)) != null) {
                        d = fontMetrics.getAscent();
                        d5 = fontMetrics.getDescent();
                        d6 = fontMetrics.charWidth(n5 == 0 ? 77 : n5);
                    }
                    System.out.println(">> MI: ascent=" + d + ", descent=" + d5 + ", width=" + d6);
                    this.setInt(6346, byArray6, 0);
                    this.setDouble(d, byArray6, 4);
                    this.setDouble(d5, byArray6, 12);
                    this.setDouble(d6, byArray6, 20);
                    outputStream.write(byArray6);
                    outputStream.flush();
                }
            }
            catch (Exception exception) {
                System.out.println("XGDworker" + this + ", exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

