/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.function;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.poi.hssf.record.formula.function.FunctionDataBuilder;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;

final class FunctionMetadataReader {
    private static final String METADATA_FILE_NAME = "functionMetadata.txt";
    private static final String ELLIPSIS = "...";
    private static final Pattern TAB_DELIM_PATTERN = Pattern.compile("\t");
    private static final Pattern SPACE_DELIM_PATTERN = Pattern.compile(" ");
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String[] DIGIT_ENDING_FUNCTION_NAMES = new String[]{"LOG10", "ATAN2", "DAYS360", "SUMXMY2", "SUMX2MY2", "SUMX2PY2"};
    private static final Set DIGIT_ENDING_FUNCTION_NAMES_SET = new HashSet<String>(Arrays.asList(DIGIT_ENDING_FUNCTION_NAMES));

    FunctionMetadataReader() {
    }

    public static FunctionMetadataRegistry createRegistry() {
        BufferedReader br;
        InputStream is = FunctionMetadataReader.class.getResourceAsStream(METADATA_FILE_NAME);
        if (is == null) {
            throw new RuntimeException("resource 'functionMetadata.txt' not found");
        }
        try {
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        FunctionDataBuilder fdb = new FunctionDataBuilder(400);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String trimLine;
                if (line.length() < 1 || line.charAt(0) == '#' || (trimLine = line.trim()).length() < 1) continue;
                FunctionMetadataReader.processLine(fdb, line);
            }
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return fdb.build();
    }

    private static void processLine(FunctionDataBuilder fdb, String line) {
        String[] parts = TAB_DELIM_PATTERN.split(line, -2);
        if (parts.length != 8) {
            throw new RuntimeException("Bad line format '" + line + "' - expected 8 data fields");
        }
        int functionIndex = FunctionMetadataReader.parseInt(parts[0]);
        String functionName = parts[1];
        int minParams = FunctionMetadataReader.parseInt(parts[2]);
        int maxParams = FunctionMetadataReader.parseInt(parts[3]);
        byte returnClassCode = FunctionMetadataReader.parseReturnTypeCode(parts[4]);
        byte[] parameterClassCodes = FunctionMetadataReader.parseOperandTypeCodes(parts[5]);
        boolean hasNote = parts[7].length() > 0;
        FunctionMetadataReader.validateFunctionName(functionName);
        fdb.add(functionIndex, functionName, minParams, maxParams, returnClassCode, parameterClassCodes, hasNote);
    }

    private static byte parseReturnTypeCode(String code) {
        if (code.length() == 0) {
            return 0;
        }
        return FunctionMetadataReader.parseOperandTypeCode(code);
    }

    private static byte[] parseOperandTypeCodes(String codes) {
        int nItems;
        if (codes.length() < 1) {
            return EMPTY_BYTE_ARRAY;
        }
        if (FunctionMetadataReader.isDash(codes)) {
            return EMPTY_BYTE_ARRAY;
        }
        String[] array = SPACE_DELIM_PATTERN.split(codes);
        if (ELLIPSIS.equals(array[(nItems = array.length) - 1])) {
            --nItems;
        }
        byte[] result = new byte[nItems];
        for (int i = 0; i < nItems; ++i) {
            result[i] = FunctionMetadataReader.parseOperandTypeCode(array[i]);
        }
        return result;
    }

    private static boolean isDash(String codes) {
        if (codes.length() == 1) {
            switch (codes.charAt(0)) {
                case '-': {
                    return true;
                }
            }
        }
        return false;
    }

    private static byte parseOperandTypeCode(String code) {
        if (code.length() != 1) {
            throw new RuntimeException("Bad operand type code format '" + code + "' expected single char");
        }
        switch (code.charAt(0)) {
            case 'V': {
                return 32;
            }
            case 'R': {
                return 0;
            }
            case 'A': {
                return 64;
            }
        }
        throw new IllegalArgumentException("Unexpected operand type code '" + code + "' (" + code.charAt(0) + ")");
    }

    private static void validateFunctionName(String functionName) {
        int len = functionName.length();
        int ix = len - 1;
        if (!Character.isDigit(functionName.charAt(ix))) {
            return;
        }
        while (ix >= 0 && Character.isDigit(functionName.charAt(ix))) {
            --ix;
        }
        if (DIGIT_ENDING_FUNCTION_NAMES_SET.contains(functionName)) {
            return;
        }
        throw new RuntimeException("Invalid function name '" + functionName + "' (is footnote number incorrectly appended)");
    }

    private static int parseInt(String valStr) {
        try {
            return Integer.parseInt(valStr);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Value '" + valStr + "' could not be parsed as an integer");
        }
    }
}

