/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class InterfaceHdrRecord
extends StandardRecord {
    public static final short sid = 225;
    private short field_1_codepage;
    public static final short CODEPAGE = 1200;

    public InterfaceHdrRecord() {
    }

    public InterfaceHdrRecord(RecordInputStream in) {
        this.field_1_codepage = in.readShort();
    }

    public void setCodepage(short cp) {
        this.field_1_codepage = cp;
    }

    public short getCodepage() {
        return this.field_1_codepage;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[INTERFACEHDR]\n");
        buffer.append("    .codepage        = ").append(Integer.toHexString(this.getCodepage())).append("\n");
        buffer.append("[/INTERFACEHDR]\n");
        return buffer.toString();
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getCodepage());
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 225;
    }
}

