/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.af.commons.Localizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.MethodHandler;
import org.mutoss.MuTossControl;
import org.mutoss.gui.MuTossGUI;

public class MuTossMenuBar
extends JMenuBar
implements ActionListener {
    protected static final Log logger = LogFactory.getLog(MuTossMenuBar.class);
    protected MuTossControl control;
    protected Localizer localizer = Localizer.getInstance();
    private JMenu menu;
    public static final String NOT_YET_IMPLEMENTED = "not yet implemented";

    public MuTossMenuBar() {
        this.add(this.makeFileMenu());
        if (System.getProperty("eclipse") != null) {
            this.add(this.makeMenuItem("R Shell", "rshell"));
            this.add(this.makeMenuItem("Throw R Error", "rerror"));
        }
    }

    protected JMenuItem makeMenuItem(String text, String action) {
        return this.makeMenuItem(text, action, true);
    }

    protected JMenuItem makeMenuItem(String text, String action, boolean enabled) {
        JMenuItem item = new JMenuItem(text);
        item.setActionCommand(action);
        item.addActionListener(this);
        item.setText(text);
        item.setEnabled(enabled);
        return item;
    }

    public void enableAllMenus() {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            this.getMenu(i).setEnabled(true);
        }
    }

    public void enableAllItems() {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            this.enableAllItems(this.getMenu(i));
        }
    }

    public void enableAllItems(JMenu menu) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (menu.getItem(i) == null) continue;
            menu.getItem(i).setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.info((Object)("Got ActionCommand " + e.getActionCommand() + "."));
        if (e.getActionCommand().equals("rshell")) {
            MuTossControl.console.setVisible(true);
        } else if (e.getActionCommand().equals("rerror")) {
            MuTossControl.getR().eval("1:20").asRChar();
        } else if (!e.getActionCommand().equals("muTossExport")) {
            if (e.getActionCommand().equals("exit")) {
                MuTossControl.getInstance();
                MuTossControl.exit(true);
            } else if (e.getActionCommand().equals("muTossFunctions")) {
                MethodHandler.updateMethods();
            } else {
                JOptionPane.showMessageDialog(MuTossGUI.getGUI(), "Not yet implemented!", "Not yet implemented!", 1);
            }
        }
    }

    public JMenu makeFileMenu() {
        JMenu menu = new JMenu("File");
        menu.add(this.makeMenuItem("Load MuToss-Object", "loadRObj"));
        menu.add(this.makeMenuItem("Export PDF File", "pdfExport"));
        menu.add(this.makeMenuItem("Export MuToss-Object to R", "muTossExport"));
        menu.add(this.makeMenuItem("Search for new MuToss functions", "muTossFunctions"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Exit", "exit"));
        return menu;
    }
}

