% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s04_all_extra.R
\docType{data}
\name{mutSigData}
\alias{mutSigData}
\title{Input Data and Examples for Running Mutational Signatures Analyses}
\format{A list with 6 elements. Each element is a different type of \code{mutSignatures} input/data:
\describe{
  \item{inputA}{data.frame with 10401 rows and 4 columns. DNA mutation data mimicking a TCGA dataset downloaded using TCGAretriever/cBio}
  \item{inputB}{data.frame with 13523 rows and 12 columns. DNA mutation data mimicking a TCGA MAF file}
  \item{inputC}{data.frame with 13523 rows and 11 columns. DNA mutation data mimicking a VCF file decorated with a SAMPLEID column}
  \item{inputC.ctx}{data.frame with 13523 rows and 11 columns. DNA mutation data mimicking a VCF file decorated with a SAMPLEID column}
  \item{inputD}{data.frame with 13487 rows and 56 columns. DNA mutation data mimicking a set of VCF files casted into a 2D matrix (samples as columns)}
  \item{blcaMUTS}{data.frame with 96 rows and 50 columns. A table of DNA mutation counts (rows are mutation types; columns are samples) }
  \item{blcaSIGS}{data.frame with 96 rows and 8 columns. Set of 8 mutational signatures (rows are mutation types; columns are signatures) }
  \item{.addON}{list of add-on functions (executed only upon request, not evaluated; these may require manual installation of external libraries from Bioconductor or GitHUB)}
}}
\source{
BLCA data were downloaded from \url{http://gdac.broadinstitute.org/} and then further processed, modified, and formatted.
}
\usage{
data("mutSigData")
}
\description{
A series of objects, including collections of DNA mutations from 50 Bladder cancer samples, 
as well as mutational signatures extracted from the same samples. Mutation catalogs were obtained
from a TCGA bladder cancer dataset (data available from the BROAD Institute). 
Original sample IDs were shuffled and then re-encoded. 
Data are available in different formats, and can be used as input for running mutational signature analyses.
}
\details{
Examples and more information are available in the vignette, as well as at the following URL: \url{http://www.mutSignatures.org/}
}
\examples{
data(mutSigData)
print(mutSigData$input.A[1:6,])
}
\keyword{datasets}
