% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{bootstrapCancerGenomes}
\alias{bootstrapCancerGenomes}
\title{Bootstrap a Mutation Count Matrix.}
\usage{
bootstrapCancerGenomes(genomes, seed = NULL)
}
\arguments{
\item{genomes}{a numeric matrix of Mutation Counts.
Rows correspond to Mutation Types, columns to different samples.}

\item{seed}{integer, set a seed to obtain reproducible results. Defaulted to NULL}
}
\value{
a numeric matrix of bootstrapped Mutation Counts.
Rows correspond to Mutation Types, columns to different samples.
}
\description{
Rearrange a Mutation count Matrix using the multivariate normal distribution. 
The function returns a bootstrapped Mutation Count matrix whose dimensions 
are identical to the input matrix.
}
\details{
This is one of the core functions included in the original mutSignatures R library, 
and in the WTSI MATLAB framework. This is an internal function.
}
\examples{
x <- cbind(c(10, 100, 20, 200, 30, 5), 
           c(100, 90, 80, 100, 11, 9))
mutSignatures:::bootstrapCancerGenomes(x)                


}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
