% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VC_library_writing.R
\name{detachAll}
\alias{detachAll}
\title{Detach all loaded packages and namespaces.}
\usage{
detachAll(reload_multiversion = FALSE, packageList = "all", dry_run = FALSE)
}
\arguments{
\item{reload_multiversion}{If multiversion needs to be loaded again after
everything (or all mentioned in \code{packageList}) is unloaded.}

\item{packageList}{A character vector with the packages to detach/unload.
Defaults to all packages (\code{names(sessionInfo()$otherPkgs}).
When package X depends on package Y, make sure you first specify Y then X.}

\item{dry_run}{If TRUE, lists all packages that will be cleaned up.}
}
\value{
When dry_run is FALSE, will returns the list of packages that it tried
to detach. When not requested, will return them invisibly. In general, this
function is called for it's side effect to unload all or some loaded packages.
}
\description{
Tries to detach all loaded packages and namespaces. Not always stable (within Rstudio).
A restart of Rstudio might be required since it will often hold on to certain namespaces.
A proper reset of all libraries is not possible, this is the best we can do. \cr
\cr
In general, it is possible to create a complete clean environment by clearing your work space,
running \code{detachAll} and then restarting Rstudio. If problems with package loading still persists,
then follow the final alternative solution described in the details section of the documentation of \code{lib.load}.
}
