% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-pipeline.R
\name{add_model}
\alias{add_model}
\title{Add a model and formula to a multiverse pipeline}
\usage{
add_model(.df, model_desc, code)
}
\arguments{
\item{.df}{The original \code{data.frame}(e.g., base data set). If part of
set of add_* decision functions in a pipeline, the base data will be passed
along as an attribute.}

\item{model_desc}{a human readable name you would like to give the model.}

\item{code}{literal model syntax you would like to run. You can use
\code{glue} inside formulas to dynamically generate variable names based on
a variable grid. For example, if you make variable grid with two versions
of your IVs (e.g., \code{iv1} and \code{iv2}), you can write your formula
like so: \code{lm(happiness ~ {iv} + control_var)}. The only requirement is
that the variables written in the formula actually exist in the underlying
data. You are also responsible for loading any packages that run a
particular model (e.g., \code{lme4} for mixed-models)}
}
\value{
a \code{data.frame} with three columns: type, group, and code. Type
indicates the decision type, group is a decision, and the code is the
actual code that will be executed. If part of a pipe, the current set of
decisions will be appended as new rows.
}
\description{
Add a model and formula to a multiverse pipeline
}
\examples{

library(tidyverse)
library(multitool)

the_data <-
  data.frame(
    id   = 1:500,
    iv1  = rnorm(500),
    iv2  = rnorm(500),
    iv3  = rnorm(500),
    mod1 = rnorm(500),
    mod2 = rnorm(500),
    mod3 = rnorm(500),
    cov1 = rnorm(500),
    cov2 = rnorm(500),
    dv1  = rnorm(500),
    dv2  = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

the_data |>
  add_filters(include1 == 0,include2 != 3,include2 != 2, include3 > -2.5) |>
  add_variables("ivs", iv1, iv2, iv3) |>
  add_variables("dvs", dv1, dv2) |>
  add_variables("mods", starts_with("mod")) |>
  add_preprocess("scale_iv", 'mutate({ivs} = scale({ivs}))') |>
  add_model("linear model", lm({dvs} ~ {ivs} * {mods}))
}
