% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ops.R
\name{within_group}
\alias{within_group}
\title{Execute code within a group}
\usage{
within_group(.self, expr)
}
\arguments{
\item{.self}{Data frame}

\item{expr}{Code to execute}
}
\value{
Data frame
}
\description{
This is the mainstay of parallel computation for a data frame. This will
execute the specified expression within each group. Each group will have a
persistent environment, so that variables created in that environment can
be referred to by, for example, later calls to summarise. This environment
contains active bindings to the columns of that data frame.
}
\examples{
\donttest{
dat <- Multiplyr (G = rep(c("A", "B"), each=50),
                  m = rep(c(5, 10), each=50),
                  alloc=1)
dat \%>\% group_by (G) \%>\% mutate (x=rnorm(length(m), mean=m))
dat \%>\% within_group ({
    mdl <- lm (x ~ 1)
})
dat \%>\% summarise (x.mean = coef(mdl)[[1]])
dat \%>\% shutdown()
}
}
\seealso{
Other data manipulations: \code{\link{mutate}},
  \code{\link{mutate_}}; \code{\link{nsa}};
  \code{\link{reduce}}, \code{\link{reduce_}};
  \code{\link{summarise}}, \code{\link{summarise_}};
  \code{\link{transmute}}, \code{\link{transmute_}};
  \code{\link{within_node}}
}

