% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nse.R, R/ops.R
\name{distinct}
\alias{distinct}
\alias{distinct_}
\title{Select unique rows or unique combinations of variables}
\usage{
distinct(.self, ..., auto_compact = NULL)

distinct_(.self, ..., .dots, auto_compact = NULL)
}
\arguments{
\item{.self}{Data frame}

\item{...}{Additional parameters}

\item{auto_compact}{Compact data after operation}

\item{.dots}{Workaround for non-standard evaluation}
}
\value{
Data frame
}
\description{
Select unique rows or unique combinations of variables
}
\details{
When called with no additional parameters, \code{distinct()}, this
function will filter out any non-unique rows in the specified data frame.
Specifying column names will limit the uniqueness checks to only those
columns, i.e. \code{distinct(G)} will limit the data frame to only
have unique values of G.

Note that if data are grouped, then this will find unique rows or
combinations for each group.
}
\examples{
\donttest{
dat <- Multiplyr (x=1:100, G=rep(c("A", "B", "C", "D"), each=25))
dat \%>\% distinct(G)
dat \%>\% shutdown()
}
}
\seealso{
Other row manipulations: \code{\link{arrange}},
  \code{\link{arrange_}}; \code{\link{filter}},
  \code{\link{filter_}}; \code{\link{group_by}},
  \code{\link{group_by_}}; \code{\link{slice}}
}

