% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.mcmc.R
\name{run.mcmc}
\alias{run.mcmc}
\title{This function runs the MCMC.}
\usage{
run.mcmc(
  M.iter,
  M.burn = NULL,
  M.thin = NULL,
  model.input,
  q = NULL,
  sv = FALSE
)
}
\arguments{
\item{M.iter}{The total number of iterations in MCMC}

\item{M.burn}{The length of the burn in}

\item{M.thin}{The number to thin the chain.  Thinning by 10 only stores every 10th run.}

\item{model.input}{A list of output created by running the create.data.R function}

\item{q}{Desired number of Moran's I basis functions in the restricted spatial regression model}

\item{sv}{A TRUE/FALSE on whether or not the MCMC output should be saved as 'MCMC.Rdata' and overwritten every 1000 iterations.  Defaults to false.}
}
\value{
A list with all standard MCMC output
}
\description{
This function runs the MCMC.
}
\examples{

data(Example)
head(detection)
head(occupancy)
head(coords)
names = list("species"=colnames(detection)[4:9],
"detection"=c("duration"),"occupancy"=c("forest","elev"))
model.input = create.data(detection, occupancy, coords, names, threshold = 15000)
out = run.mcmc(M.iter=3, M.burn=1, M.thin=1, model.input, q=10, sv=FALSE)
}
