% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClosedSCR.R
\name{getdensityClosedSCR}
\alias{getdensityClosedSCR}
\title{Calculate population density estimates}
\usage{
getdensityClosedSCR(out)
}
\arguments{
\item{out}{List of output returned by \code{\link{multimarkClosedSCR}}.}
}
\value{
An object of class \code{\link[coda]{mcmc.list}} containing the following:
\item{D}{Posterior samples for density.}
}
\description{
This function calculates posterior population density estimates from \code{\link{multimarkClosedSCR}} output as D = N/A, where D is density, N is abundance, and A is the area of available habitat within the study area.
}
\examples{
\donttest{
# This example is excluded from testing to reduce package check time
# Example uses unrealistically low values for nchain, iter, and burnin

#Run behavior model for simulated data with constant detection probability (i.e., mod.p=~c)
sim.data<-simdataClosedSCR()
Enc.Mat<-sim.data$Enc.Mat
trapCoords<-sim.data$spatialInputs$trapCoords
studyArea<-sim.data$spatialInputs$studyArea
example.dot <- multimarkClosedSCR(Enc.Mat,trapCoords,studyArea,mod.p=~1)
  
#Calculate capture and recapture probabilities
D <- getdensityClosedSCR(example.dot)
summary(D)}

}
\seealso{
\code{\link{multimarkClosedSCR}}
}
\author{
Brett T. McClintock
}
