% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{synthetic_gfk}
\alias{synthetic_gfk}
\title{Synthetic scanner data for one consumer electronic product}
\format{
data frame with 5509 rows and 15 variables
\describe{
  \item{month_num}{Month number, 0-25}
  \item{char1-11}{Product characteristics}
  \item{prodid_num}{Product identifier, created from unique characteristics}
  \item{quantity}{The quantity of items sold in that month as an integer}
  \item{value}{Sales total (NZD)}}
}
\source{
{GfK New Zealand}
}
\usage{
synthetic_gfk
}
\description{
GfK have made this available as a public good for the international statistical community, to aid research into new price index methods.
}
\details{
The data is based on one product category from the scanner data used in production of the New Zealand Consumers Price Index.

The synthetic data has been heavily modified to remove identification potential, while still retaining some of the characteristics of
scanner data which make traditional index methods inadequate - such as high product turnover and volatile price and quantities - which motivate
the multilateral index methods that are currently being researched within the international statistical community.
}
\keyword{datasets}
