#' multigroup: methods for multigroup data analysis
#'
#' This package includes several methods to study multigroup data, 
#' where the same set of variables are measured on different groups of
#' individuals.
#'
#' @section Some Functions:
#'
#' multigroup provides a set of functions for multigroup analysis:
#'
#' \itemize{
#'   \item \code{\link{BGC}}: Between Group Comparison
#'   \item \code{\link{DCCSWA}}: Dual Common Component and Specific Weights Analysis
#'   \item \code{\link{DGPA}}: Dual Generalized Procrustes Analysis
#'   \item \code{\link{DSTATIS}}: Dual STATIS
#'   \item \code{\link{FCPCA}}: Flury's Common Principal Component Analysis
#'   \item \code{\link{mgPCA}}:Multigroup Principal Component Analysis
#'   \item \code{\link{mgPLS}}: Multigroup Partial Least Squares Regression
#'   \item \code{\link{mbmgPCA}}: Multiblock and multigroup PCA
#' }
#'
#' @docType package
#' @importFrom MASS ginv
#' @name multigroup
NULL
