% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{disco}
\alias{disco}
\title{Distinctive and Common Components with SCA - DISCO}
\usage{
disco(X, ncomp = 2, ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{ncomp}{\code{integer} number of components to extract.}

\item{...}{additional arguments (not used).}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{RegularizedSCA::DISCOsca} function for computing DISCO.
}
\details{
DISCO is a restriction of SCA where Alternating Least Squares is used for
estimation of loadings and scores. The SCA solution is rotated towards loadings (in sample linked mode) which are filled with
zeros in a pattern resembling distinct, local and common components.
When used in sample linked mode and only selecting distinct components, it shares a
resemblance to SO-PLS, only in an unsupervised setting. Explained variances
are computed as proportion of block varation explained by scores*loadings'.
}
\examples{
data(potato)
potList <- as.list(potato[c(1,2,9)])
pot.disco  <- disco(potList)
plot(scores(pot.disco), labels="names")

}
\references{
Schouteden, M., Van Deun, K., Wilderjans, T. F., & Van Mechelen, I. (2014). Performing DISCO-SCA to search for distinctive and common information in linked data. Behavior research methods, 46(2), 576-587.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
